/* THIS FILE IS AUTOGENERATED FROM Request.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_REQUESTBINDING_H_
#define DOM_REQUESTBINDING_H_

#include "FetchBinding.h"
#include "FetchObserverBinding.h"
#include "HeadersBinding.h"
#include "ReferrerPolicyBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/AbortSignal.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"
#include "nsIPrincipal.h"

class nsIPrincipal;

namespace mozilla {
namespace dom {

class AbortSignal;
class BlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString;
class ByteStringSequenceSequenceOrByteStringByteStringRecord;
struct NativePropertyHooks;
class ObserverCallback;
class OwningBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString;
class OwningByteStringSequenceSequenceOrByteStringByteStringRecord;
class OwningRequestOrUTF8String;
class ProtoAndIfaceCache;
class Request;
struct RequestInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class RequestDestination : uint8_t {
  _empty,
  Audio,
  Audioworklet,
  Document,
  Embed,
  Font,
  Frame,
  Iframe,
  Image,
  Json,
  Manifest,
  Object,
  Paintworklet,
  Report,
  Script,
  Sharedworker,
  Style,
  Track,
  Video,
  Worker,
  Xslt,
};

namespace binding_detail {
template <> struct EnumStrings<RequestDestination> {
  static constexpr nsLiteralCString Values[21] {
    ""_ns,
    "audio"_ns,
    "audioworklet"_ns,
    "document"_ns,
    "embed"_ns,
    "font"_ns,
    "frame"_ns,
    "iframe"_ns,
    "image"_ns,
    "json"_ns,
    "manifest"_ns,
    "object"_ns,
    "paintworklet"_ns,
    "report"_ns,
    "script"_ns,
    "sharedworker"_ns,
    "style"_ns,
    "track"_ns,
    "video"_ns,
    "worker"_ns,
    "xslt"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestDestination aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestMode : uint8_t {
  Same_origin,
  No_cors,
  Cors,
  Navigate,
};

namespace binding_detail {
template <> struct EnumStrings<RequestMode> {
  static constexpr nsLiteralCString Values[4] {
    "same-origin"_ns,
    "no-cors"_ns,
    "cors"_ns,
    "navigate"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestCredentials : uint8_t {
  Omit,
  Same_origin,
  Include,
};

namespace binding_detail {
template <> struct EnumStrings<RequestCredentials> {
  static constexpr nsLiteralCString Values[3] {
    "omit"_ns,
    "same-origin"_ns,
    "include"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestCredentials aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestCache : uint8_t {
  Default,
  No_store,
  Reload,
  No_cache,
  Force_cache,
  Only_if_cached,
};

namespace binding_detail {
template <> struct EnumStrings<RequestCache> {
  static constexpr nsLiteralCString Values[6] {
    "default"_ns,
    "no-store"_ns,
    "reload"_ns,
    "no-cache"_ns,
    "force-cache"_ns,
    "only-if-cached"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestCache aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestRedirect : uint8_t {
  Follow,
  Error,
  Manual,
};

namespace binding_detail {
template <> struct EnumStrings<RequestRedirect> {
  static constexpr nsLiteralCString Values[3] {
    "follow"_ns,
    "error"_ns,
    "manual"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestRedirect aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestPriority : uint8_t {
  High,
  Low,
  Auto,
};

namespace binding_detail {
template <> struct EnumStrings<RequestPriority> {
  static constexpr nsLiteralCString Values[3] {
    "high"_ns,
    "low"_ns,
    "auto"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RequestPriority aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRequestOrUTF8String& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningRequestOrUTF8String& aUnion);


struct RequestInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<OwningBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString >> mBody;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestCache> mCache;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestCredentials> mCredentials;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningByteStringSequenceSequenceOrByteStringByteStringRecord> mHeaders;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIntegrity;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mKeepalive;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mMethod;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestMode> mMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mMozErrors;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mNeverTaint;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<ObserverCallback>> mObserve;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestPriority> mPriority;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestRedirect> mRedirect;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mReferrer;
  MOZ_INIT_OUTSIDE_CTOR Optional<ReferrerPolicy> mReferrerPolicy;
  MOZ_INIT_OUTSIDE_CTOR Optional<RefPtr<mozilla::dom::AbortSignal>> mSignal;
  MOZ_INIT_OUTSIDE_CTOR Optional<RefPtr<nsIPrincipal>> mTriggeringPrincipal;

  RequestInit();

  explicit inline RequestInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RequestInit(RequestInit&& aOther) = default;

private:
  RequestInit(const RequestInit&) = delete;
  RequestInit& operator=(const RequestInit&) = delete;

  static bool
  InitIds(JSContext* cx, RequestInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBody, "mBody", aFlags);
    ImplCycleCollectionTraverse(aCallback, mObserve, "mObserve", aFlags);
    ImplCycleCollectionTraverse(aCallback, mSignal, "mSignal", aFlags);
    ImplCycleCollectionTraverse(aCallback, mTriggeringPrincipal, "mTriggeringPrincipal", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBody);
    ImplCycleCollectionUnlink(mObserve);
    ImplCycleCollectionUnlink(mSignal);
    ImplCycleCollectionUnlink(mTriggeringPrincipal);
  }
};

namespace binding_detail {
struct FastRequestInit : public RequestInit
{
  inline FastRequestInit()
    : RequestInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RequestOrUTF8String : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRequest,
    eUTF8String
  };
public:
  enum class Type
  {
    eRequest = TypeOrUninit::eRequest,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Request> > mRequest;
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  RequestOrUTF8String(const RequestOrUTF8String&) = delete;
  RequestOrUTF8String& operator=(const RequestOrUTF8String&) = delete;
public:
  explicit inline RequestOrUTF8String()
    : mType(eUninitialized)
  {
  }

  inline ~RequestOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Request>&
  RawSetAsRequest()
  {
    if (mType == eRequest) {
      return mValue.mRequest.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRequest;
    return mValue.mRequest.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Request>&
  SetAsRequest()
  {
    if (mType == eRequest) {
      return mValue.mRequest.Value();
    }
    Uninit();
    mType = eRequest;
    return mValue.mRequest.SetValue();
  }

  inline bool
  IsRequest() const
  {
    return mType == eRequest;
  }

  inline NonNull<mozilla::dom::Request>&
  GetAsRequest()
  {
    MOZ_RELEASE_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline mozilla::dom::Request&
  GetAsRequest() const
  {
    MOZ_RELEASE_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRequest: {
        DestroyRequest();
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToRequest(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRequest(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRequest()
  {
    MOZ_RELEASE_ASSERT(IsRequest(), "Wrong type!");
    mValue.mRequest.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};


class OwningRequestOrUTF8String : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningRequestOrUTF8String& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eRequest,
    eUTF8String
  };
public:
  enum class Type
  {
    eRequest = TypeOrUninit::eRequest,
    eUTF8String = TypeOrUninit::eUTF8String
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Request> > mRequest;
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRequestOrUTF8String()
    : mType(eUninitialized)
  {
  }

  OwningRequestOrUTF8String(OwningRequestOrUTF8String&& aOther);

  explicit inline OwningRequestOrUTF8String(const OwningRequestOrUTF8String& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRequestOrUTF8String()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Request>&
  RawSetAsRequest();

  [[nodiscard]] OwningNonNull<mozilla::dom::Request>&
  SetAsRequest();

  inline bool
  IsRequest() const
  {
    return mType == eRequest;
  }

  inline OwningNonNull<mozilla::dom::Request>&
  GetAsRequest()
  {
    MOZ_RELEASE_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline OwningNonNull<mozilla::dom::Request> const &
  GetAsRequest() const
  {
    MOZ_RELEASE_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningRequestOrUTF8String&
  operator=(OwningRequestOrUTF8String&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRequestOrUTF8String&
  operator=(const OwningRequestOrUTF8String& aOther);

private:
  bool
  TrySetToRequest(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRequest(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRequest();

  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};


namespace Request_Binding {

  typedef mozilla::dom::Request NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::Request* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Request,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Request_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::RequestDestination>
{
  static constexpr dom::RequestDestination value = dom::RequestDestination::Xslt;

  static_assert(static_cast<uint8_t>(dom::RequestDestination::_empty) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::RequestDestination>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::RequestMode>
{
  static constexpr dom::RequestMode value = dom::RequestMode::Navigate;

  static_assert(static_cast<uint8_t>(dom::RequestMode::Same_origin) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::RequestMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::RequestCredentials>
{
  static constexpr dom::RequestCredentials value = dom::RequestCredentials::Include;

  static_assert(static_cast<uint8_t>(dom::RequestCredentials::Omit) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::RequestCredentials>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::RequestCache>
{
  static constexpr dom::RequestCache value = dom::RequestCache::Only_if_cached;

  static_assert(static_cast<uint8_t>(dom::RequestCache::Default) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::RequestCache>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::RequestRedirect>
{
  static constexpr dom::RequestRedirect value = dom::RequestRedirect::Manual;

  static_assert(static_cast<uint8_t>(dom::RequestRedirect::Follow) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::RequestRedirect>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::RequestPriority>
{
  static constexpr dom::RequestPriority value = dom::RequestPriority::Auto;

  static_assert(static_cast<uint8_t>(dom::RequestPriority::High) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::RequestPriority>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_REQUESTBINDING_H_
