/* THIS FILE IS AUTOGENERATED FROM WebGPU.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_WEBGPUBINDING_H_
#define DOM_WEBGPUBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/webgpu/BindGroupLayout.h"
#include "mozilla/webgpu/Buffer.h"
#include "mozilla/webgpu/Device.h"
#include "mozilla/webgpu/QuerySet.h"
#include "mozilla/webgpu/ShaderModule.h"
#include "mozilla/webgpu/Texture.h"
#include "mozilla/webgpu/TextureView.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {

namespace dom {

class DoubleSequenceOrGPUColorDict;
struct GPUBindGroupDescriptorAtoms;
struct GPUBindGroupEntry;
struct GPUBindGroupEntryAtoms;
struct GPUBindGroupLayoutDescriptorAtoms;
struct GPUBindGroupLayoutEntry;
struct GPUBindGroupLayoutEntryAtoms;
struct GPUBlendComponent;
struct GPUBlendComponentAtoms;
struct GPUBlendState;
struct GPUBlendStateAtoms;
struct GPUBufferBindingAtoms;
struct GPUBufferBindingLayout;
struct GPUBufferBindingLayoutAtoms;
struct GPUBufferDescriptorAtoms;
class GPUBufferUsage;
struct GPUCanvasConfigurationAtoms;
struct GPUColorDictAtoms;
struct GPUColorTargetState;
struct GPUColorTargetStateAtoms;
class GPUColorWrite;
struct GPUComputePassDescriptorAtoms;
struct GPUComputePassTimestampWrites;
struct GPUComputePassTimestampWritesAtoms;
struct GPUComputePipelineDescriptorAtoms;
struct GPUCopyExternalImageDestInfoAtoms;
struct GPUCopyExternalImageSourceInfoAtoms;
struct GPUDepthStencilState;
struct GPUDepthStencilStateAtoms;
struct GPUDeviceDescriptorAtoms;
struct GPUExtent3DDictAtoms;
struct GPUFragmentState;
struct GPUFragmentStateAtoms;
class GPUMapMode;
struct GPUMultisampleState;
struct GPUMultisampleStateAtoms;
struct GPUObjectDescriptorBaseAtoms;
struct GPUOrigin2DDictAtoms;
struct GPUOrigin3DDictAtoms;
struct GPUPipelineDescriptorBaseAtoms;
struct GPUPipelineErrorInitAtoms;
struct GPUPipelineLayoutDescriptorAtoms;
class GPUPipelineLayoutOrGPUAutoLayoutMode;
struct GPUPrimitiveState;
struct GPUPrimitiveStateAtoms;
struct GPUProgrammableStage;
struct GPUProgrammableStageAtoms;
struct GPUQuerySetDescriptorAtoms;
struct GPUQueueDescriptor;
struct GPURenderBundleEncoderDescriptorAtoms;
struct GPURenderPassColorAttachment;
struct GPURenderPassColorAttachmentAtoms;
struct GPURenderPassDepthStencilAttachment;
struct GPURenderPassDepthStencilAttachmentAtoms;
struct GPURenderPassDescriptorAtoms;
struct GPURenderPassLayoutAtoms;
struct GPURenderPassTimestampWrites;
struct GPURenderPassTimestampWritesAtoms;
struct GPURenderPipelineDescriptorAtoms;
struct GPURequestAdapterOptionsAtoms;
struct GPUSamplerBindingLayout;
struct GPUSamplerBindingLayoutAtoms;
struct GPUSamplerDescriptorAtoms;
class GPUSamplerOrGPUTextureViewOrGPUBufferBinding;
struct GPUShaderModuleCompilationHint;
struct GPUShaderModuleCompilationHintAtoms;
struct GPUShaderModuleDescriptorAtoms;
class GPUShaderStage;
struct GPUStencilFaceState;
struct GPUStencilFaceStateAtoms;
struct GPUStorageTextureBindingLayout;
struct GPUStorageTextureBindingLayoutAtoms;
struct GPUTexelCopyBufferInfoAtoms;
struct GPUTexelCopyBufferLayoutAtoms;
struct GPUTexelCopyTextureInfoAtoms;
struct GPUTextureBindingLayout;
struct GPUTextureBindingLayoutAtoms;
struct GPUTextureDescriptorAtoms;
class GPUTextureUsage;
struct GPUTextureViewDescriptorAtoms;
struct GPUVertexAttribute;
struct GPUVertexAttributeAtoms;
struct GPUVertexBufferLayout;
struct GPUVertexBufferLayoutAtoms;
struct GPUVertexState;
struct GPUVertexStateAtoms;
class HTMLCanvasElement;
class HTMLImageElement;
class ImageBitmap;
class ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas;
struct NativePropertyHooks;
class OffscreenCanvas;
class OwningDoubleSequenceOrGPUColorDict;
class OwningGPUPipelineLayoutOrGPUAutoLayoutMode;
class OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding;
class OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas;
class OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict;
class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict;
class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict;
class ProtoAndIfaceCache;
class RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict;
class RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict;
class RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict;

} // namespace dom

namespace webgpu {

class Adapter;
class AdapterInfo;
class BindGroup;
class BindGroupLayout;
class Buffer;
class CanvasContext;
class CommandBuffer;
class CommandEncoder;
class CompilationInfo;
class CompilationMessage;
class ComputePassEncoder;
class ComputePipeline;
class Device;
class DeviceLostInfo;
class Error;
class ExtTex;
class Instance;
class InternalError;
class OutOfMemoryError;
class PipelineError;
class PipelineLayout;
class QuerySet;
class Queue;
class RenderBundle;
class RenderBundleEncoder;
class RenderPassEncoder;
class RenderPipeline;
class Sampler;
class ShaderModule;
class SupportedFeatures;
class SupportedLimits;
class Texture;
class TextureView;
class ValidationError;
class WGSLLanguageFeatures;

} // namespace webgpu

} // namespace mozilla

namespace mozilla {

namespace dom {

enum class GPUPowerPreference : uint8_t {
  Low_power,
  High_performance,
};

namespace binding_detail {
template <> struct EnumStrings<GPUPowerPreference> {
  static constexpr nsLiteralCString Values[2] {
    "low-power"_ns,
    "high-performance"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUPowerPreference aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFeatureName : uint8_t {
  Depth_clip_control,
  Depth32float_stencil8,
  Texture_compression_bc,
  Texture_compression_bc_sliced_3d,
  Texture_compression_etc2,
  Texture_compression_astc,
  Texture_compression_astc_sliced_3d,
  Timestamp_query,
  Indirect_first_instance,
  Shader_f16,
  Rg11b10ufloat_renderable,
  Bgra8unorm_storage,
  Float32_filterable,
  Float32_blendable,
  Clip_distances,
  Dual_source_blending,
  Subgroups,
  Core_features_and_limits,
};

namespace binding_detail {
template <> struct EnumStrings<GPUFeatureName> {
  static constexpr nsLiteralCString Values[18] {
    "depth-clip-control"_ns,
    "depth32float-stencil8"_ns,
    "texture-compression-bc"_ns,
    "texture-compression-bc-sliced-3d"_ns,
    "texture-compression-etc2"_ns,
    "texture-compression-astc"_ns,
    "texture-compression-astc-sliced-3d"_ns,
    "timestamp-query"_ns,
    "indirect-first-instance"_ns,
    "shader-f16"_ns,
    "rg11b10ufloat-renderable"_ns,
    "bgra8unorm-storage"_ns,
    "float32-filterable"_ns,
    "float32-blendable"_ns,
    "clip-distances"_ns,
    "dual-source-blending"_ns,
    "subgroups"_ns,
    "core-features-and-limits"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUFeatureName aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBufferMapState : uint8_t {
  Unmapped,
  Pending,
  Mapped,
};

namespace binding_detail {
template <> struct EnumStrings<GPUBufferMapState> {
  static constexpr nsLiteralCString Values[3] {
    "unmapped"_ns,
    "pending"_ns,
    "mapped"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUBufferMapState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureDimension : uint8_t {
  _1d,
  _2d,
  _3d,
};

namespace binding_detail {
template <> struct EnumStrings<GPUTextureDimension> {
  static constexpr nsLiteralCString Values[3] {
    "1d"_ns,
    "2d"_ns,
    "3d"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUTextureDimension aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureViewDimension : uint8_t {
  _1d,
  _2d,
  _2d_array,
  Cube,
  Cube_array,
  _3d,
};

namespace binding_detail {
template <> struct EnumStrings<GPUTextureViewDimension> {
  static constexpr nsLiteralCString Values[6] {
    "1d"_ns,
    "2d"_ns,
    "2d-array"_ns,
    "cube"_ns,
    "cube-array"_ns,
    "3d"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUTextureViewDimension aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureAspect : uint8_t {
  All,
  Stencil_only,
  Depth_only,
};

namespace binding_detail {
template <> struct EnumStrings<GPUTextureAspect> {
  static constexpr nsLiteralCString Values[3] {
    "all"_ns,
    "stencil-only"_ns,
    "depth-only"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUTextureAspect aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureFormat : uint8_t {
  R8unorm,
  R8snorm,
  R8uint,
  R8sint,
  R16uint,
  R16sint,
  R16float,
  Rg8unorm,
  Rg8snorm,
  Rg8uint,
  Rg8sint,
  R32uint,
  R32sint,
  R32float,
  Rg16uint,
  Rg16sint,
  Rg16float,
  Rgba8unorm,
  Rgba8unorm_srgb,
  Rgba8snorm,
  Rgba8uint,
  Rgba8sint,
  Bgra8unorm,
  Bgra8unorm_srgb,
  Rgb9e5ufloat,
  Rgb10a2uint,
  Rgb10a2unorm,
  Rg11b10ufloat,
  Rg32uint,
  Rg32sint,
  Rg32float,
  Rgba16uint,
  Rgba16sint,
  Rgba16float,
  Rgba32uint,
  Rgba32sint,
  Rgba32float,
  Stencil8,
  Depth16unorm,
  Depth24plus,
  Depth24plus_stencil8,
  Depth32float,
  Depth32float_stencil8,
  Bc1_rgba_unorm,
  Bc1_rgba_unorm_srgb,
  Bc2_rgba_unorm,
  Bc2_rgba_unorm_srgb,
  Bc3_rgba_unorm,
  Bc3_rgba_unorm_srgb,
  Bc4_r_unorm,
  Bc4_r_snorm,
  Bc5_rg_unorm,
  Bc5_rg_snorm,
  Bc6h_rgb_ufloat,
  Bc6h_rgb_float,
  Bc7_rgba_unorm,
  Bc7_rgba_unorm_srgb,
  Etc2_rgb8unorm,
  Etc2_rgb8unorm_srgb,
  Etc2_rgb8a1unorm,
  Etc2_rgb8a1unorm_srgb,
  Etc2_rgba8unorm,
  Etc2_rgba8unorm_srgb,
  Eac_r11unorm,
  Eac_r11snorm,
  Eac_rg11unorm,
  Eac_rg11snorm,
  Astc_4x4_unorm,
  Astc_4x4_unorm_srgb,
  Astc_5x4_unorm,
  Astc_5x4_unorm_srgb,
  Astc_5x5_unorm,
  Astc_5x5_unorm_srgb,
  Astc_6x5_unorm,
  Astc_6x5_unorm_srgb,
  Astc_6x6_unorm,
  Astc_6x6_unorm_srgb,
  Astc_8x5_unorm,
  Astc_8x5_unorm_srgb,
  Astc_8x6_unorm,
  Astc_8x6_unorm_srgb,
  Astc_8x8_unorm,
  Astc_8x8_unorm_srgb,
  Astc_10x5_unorm,
  Astc_10x5_unorm_srgb,
  Astc_10x6_unorm,
  Astc_10x6_unorm_srgb,
  Astc_10x8_unorm,
  Astc_10x8_unorm_srgb,
  Astc_10x10_unorm,
  Astc_10x10_unorm_srgb,
  Astc_12x10_unorm,
  Astc_12x10_unorm_srgb,
  Astc_12x12_unorm,
  Astc_12x12_unorm_srgb,
};

namespace binding_detail {
template <> struct EnumStrings<GPUTextureFormat> {
  static constexpr nsLiteralCString Values[95] {
    "r8unorm"_ns,
    "r8snorm"_ns,
    "r8uint"_ns,
    "r8sint"_ns,
    "r16uint"_ns,
    "r16sint"_ns,
    "r16float"_ns,
    "rg8unorm"_ns,
    "rg8snorm"_ns,
    "rg8uint"_ns,
    "rg8sint"_ns,
    "r32uint"_ns,
    "r32sint"_ns,
    "r32float"_ns,
    "rg16uint"_ns,
    "rg16sint"_ns,
    "rg16float"_ns,
    "rgba8unorm"_ns,
    "rgba8unorm-srgb"_ns,
    "rgba8snorm"_ns,
    "rgba8uint"_ns,
    "rgba8sint"_ns,
    "bgra8unorm"_ns,
    "bgra8unorm-srgb"_ns,
    "rgb9e5ufloat"_ns,
    "rgb10a2uint"_ns,
    "rgb10a2unorm"_ns,
    "rg11b10ufloat"_ns,
    "rg32uint"_ns,
    "rg32sint"_ns,
    "rg32float"_ns,
    "rgba16uint"_ns,
    "rgba16sint"_ns,
    "rgba16float"_ns,
    "rgba32uint"_ns,
    "rgba32sint"_ns,
    "rgba32float"_ns,
    "stencil8"_ns,
    "depth16unorm"_ns,
    "depth24plus"_ns,
    "depth24plus-stencil8"_ns,
    "depth32float"_ns,
    "depth32float-stencil8"_ns,
    "bc1-rgba-unorm"_ns,
    "bc1-rgba-unorm-srgb"_ns,
    "bc2-rgba-unorm"_ns,
    "bc2-rgba-unorm-srgb"_ns,
    "bc3-rgba-unorm"_ns,
    "bc3-rgba-unorm-srgb"_ns,
    "bc4-r-unorm"_ns,
    "bc4-r-snorm"_ns,
    "bc5-rg-unorm"_ns,
    "bc5-rg-snorm"_ns,
    "bc6h-rgb-ufloat"_ns,
    "bc6h-rgb-float"_ns,
    "bc7-rgba-unorm"_ns,
    "bc7-rgba-unorm-srgb"_ns,
    "etc2-rgb8unorm"_ns,
    "etc2-rgb8unorm-srgb"_ns,
    "etc2-rgb8a1unorm"_ns,
    "etc2-rgb8a1unorm-srgb"_ns,
    "etc2-rgba8unorm"_ns,
    "etc2-rgba8unorm-srgb"_ns,
    "eac-r11unorm"_ns,
    "eac-r11snorm"_ns,
    "eac-rg11unorm"_ns,
    "eac-rg11snorm"_ns,
    "astc-4x4-unorm"_ns,
    "astc-4x4-unorm-srgb"_ns,
    "astc-5x4-unorm"_ns,
    "astc-5x4-unorm-srgb"_ns,
    "astc-5x5-unorm"_ns,
    "astc-5x5-unorm-srgb"_ns,
    "astc-6x5-unorm"_ns,
    "astc-6x5-unorm-srgb"_ns,
    "astc-6x6-unorm"_ns,
    "astc-6x6-unorm-srgb"_ns,
    "astc-8x5-unorm"_ns,
    "astc-8x5-unorm-srgb"_ns,
    "astc-8x6-unorm"_ns,
    "astc-8x6-unorm-srgb"_ns,
    "astc-8x8-unorm"_ns,
    "astc-8x8-unorm-srgb"_ns,
    "astc-10x5-unorm"_ns,
    "astc-10x5-unorm-srgb"_ns,
    "astc-10x6-unorm"_ns,
    "astc-10x6-unorm-srgb"_ns,
    "astc-10x8-unorm"_ns,
    "astc-10x8-unorm-srgb"_ns,
    "astc-10x10-unorm"_ns,
    "astc-10x10-unorm-srgb"_ns,
    "astc-12x10-unorm"_ns,
    "astc-12x10-unorm-srgb"_ns,
    "astc-12x12-unorm"_ns,
    "astc-12x12-unorm-srgb"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUTextureFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUAddressMode : uint8_t {
  Clamp_to_edge,
  Repeat,
  Mirror_repeat,
};

namespace binding_detail {
template <> struct EnumStrings<GPUAddressMode> {
  static constexpr nsLiteralCString Values[3] {
    "clamp-to-edge"_ns,
    "repeat"_ns,
    "mirror-repeat"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUAddressMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFilterMode : uint8_t {
  Nearest,
  Linear,
};

namespace binding_detail {
template <> struct EnumStrings<GPUFilterMode> {
  static constexpr nsLiteralCString Values[2] {
    "nearest"_ns,
    "linear"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUFilterMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUMipmapFilterMode : uint8_t {
  Nearest,
  Linear,
};

namespace binding_detail {
template <> struct EnumStrings<GPUMipmapFilterMode> {
  static constexpr nsLiteralCString Values[2] {
    "nearest"_ns,
    "linear"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUMipmapFilterMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCompareFunction : uint8_t {
  Never,
  Less,
  Equal,
  Less_equal,
  Greater,
  Not_equal,
  Greater_equal,
  Always,
};

namespace binding_detail {
template <> struct EnumStrings<GPUCompareFunction> {
  static constexpr nsLiteralCString Values[8] {
    "never"_ns,
    "less"_ns,
    "equal"_ns,
    "less-equal"_ns,
    "greater"_ns,
    "not-equal"_ns,
    "greater-equal"_ns,
    "always"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUCompareFunction aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBufferBindingType : uint8_t {
  Uniform,
  Storage,
  Read_only_storage,
};

namespace binding_detail {
template <> struct EnumStrings<GPUBufferBindingType> {
  static constexpr nsLiteralCString Values[3] {
    "uniform"_ns,
    "storage"_ns,
    "read-only-storage"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUBufferBindingType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUSamplerBindingType : uint8_t {
  Filtering,
  Non_filtering,
  Comparison,
};

namespace binding_detail {
template <> struct EnumStrings<GPUSamplerBindingType> {
  static constexpr nsLiteralCString Values[3] {
    "filtering"_ns,
    "non-filtering"_ns,
    "comparison"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUSamplerBindingType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureSampleType : uint8_t {
  Float,
  Unfilterable_float,
  Depth,
  Sint,
  Uint,
};

namespace binding_detail {
template <> struct EnumStrings<GPUTextureSampleType> {
  static constexpr nsLiteralCString Values[5] {
    "float"_ns,
    "unfilterable-float"_ns,
    "depth"_ns,
    "sint"_ns,
    "uint"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUTextureSampleType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStorageTextureAccess : uint8_t {
  Write_only,
  Read_only,
  Read_write,
};

namespace binding_detail {
template <> struct EnumStrings<GPUStorageTextureAccess> {
  static constexpr nsLiteralCString Values[3] {
    "write-only"_ns,
    "read-only"_ns,
    "read-write"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUStorageTextureAccess aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCompilationMessageType : uint8_t {
  Error,
  Warning,
  Info,
};

namespace binding_detail {
template <> struct EnumStrings<GPUCompilationMessageType> {
  static constexpr nsLiteralCString Values[3] {
    "error"_ns,
    "warning"_ns,
    "info"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUCompilationMessageType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUPipelineErrorReason : uint8_t {
  Validation,
  Internal,
};

namespace binding_detail {
template <> struct EnumStrings<GPUPipelineErrorReason> {
  static constexpr nsLiteralCString Values[2] {
    "validation"_ns,
    "internal"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUPipelineErrorReason aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUAutoLayoutMode : uint8_t {
  Auto,
};

namespace binding_detail {
template <> struct EnumStrings<GPUAutoLayoutMode> {
  static constexpr nsLiteralCString Values[1] {
    "auto"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUAutoLayoutMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUPrimitiveTopology : uint8_t {
  Point_list,
  Line_list,
  Line_strip,
  Triangle_list,
  Triangle_strip,
};

namespace binding_detail {
template <> struct EnumStrings<GPUPrimitiveTopology> {
  static constexpr nsLiteralCString Values[5] {
    "point-list"_ns,
    "line-list"_ns,
    "line-strip"_ns,
    "triangle-list"_ns,
    "triangle-strip"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUPrimitiveTopology aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFrontFace : uint8_t {
  Ccw,
  Cw,
};

namespace binding_detail {
template <> struct EnumStrings<GPUFrontFace> {
  static constexpr nsLiteralCString Values[2] {
    "ccw"_ns,
    "cw"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUFrontFace aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCullMode : uint8_t {
  None,
  Front,
  Back,
};

namespace binding_detail {
template <> struct EnumStrings<GPUCullMode> {
  static constexpr nsLiteralCString Values[3] {
    "none"_ns,
    "front"_ns,
    "back"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUCullMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBlendFactor : uint8_t {
  Zero,
  One,
  Src,
  One_minus_src,
  Src_alpha,
  One_minus_src_alpha,
  Dst,
  One_minus_dst,
  Dst_alpha,
  One_minus_dst_alpha,
  Src_alpha_saturated,
  Constant,
  One_minus_constant,
};

namespace binding_detail {
template <> struct EnumStrings<GPUBlendFactor> {
  static constexpr nsLiteralCString Values[13] {
    "zero"_ns,
    "one"_ns,
    "src"_ns,
    "one-minus-src"_ns,
    "src-alpha"_ns,
    "one-minus-src-alpha"_ns,
    "dst"_ns,
    "one-minus-dst"_ns,
    "dst-alpha"_ns,
    "one-minus-dst-alpha"_ns,
    "src-alpha-saturated"_ns,
    "constant"_ns,
    "one-minus-constant"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUBlendFactor aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBlendOperation : uint8_t {
  Add,
  Subtract,
  Reverse_subtract,
  Min,
  Max,
};

namespace binding_detail {
template <> struct EnumStrings<GPUBlendOperation> {
  static constexpr nsLiteralCString Values[5] {
    "add"_ns,
    "subtract"_ns,
    "reverse-subtract"_ns,
    "min"_ns,
    "max"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUBlendOperation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStencilOperation : uint8_t {
  Keep,
  Zero,
  Replace,
  Invert,
  Increment_clamp,
  Decrement_clamp,
  Increment_wrap,
  Decrement_wrap,
};

namespace binding_detail {
template <> struct EnumStrings<GPUStencilOperation> {
  static constexpr nsLiteralCString Values[8] {
    "keep"_ns,
    "zero"_ns,
    "replace"_ns,
    "invert"_ns,
    "increment-clamp"_ns,
    "decrement-clamp"_ns,
    "increment-wrap"_ns,
    "decrement-wrap"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUStencilOperation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUIndexFormat : uint8_t {
  Uint16,
  Uint32,
};

namespace binding_detail {
template <> struct EnumStrings<GPUIndexFormat> {
  static constexpr nsLiteralCString Values[2] {
    "uint16"_ns,
    "uint32"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUIndexFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUVertexFormat : uint8_t {
  Uint8,
  Uint8x2,
  Uint8x4,
  Sint8,
  Sint8x2,
  Sint8x4,
  Unorm8,
  Unorm8x2,
  Unorm8x4,
  Snorm8,
  Snorm8x2,
  Snorm8x4,
  Uint16,
  Uint16x2,
  Uint16x4,
  Sint16,
  Sint16x2,
  Sint16x4,
  Unorm16,
  Unorm16x2,
  Unorm16x4,
  Snorm16,
  Snorm16x2,
  Snorm16x4,
  Float16,
  Float16x2,
  Float16x4,
  Float32,
  Float32x2,
  Float32x3,
  Float32x4,
  Uint32,
  Uint32x2,
  Uint32x3,
  Uint32x4,
  Sint32,
  Sint32x2,
  Sint32x3,
  Sint32x4,
  Unorm10_10_10_2,
  Unorm8x4_bgra,
};

namespace binding_detail {
template <> struct EnumStrings<GPUVertexFormat> {
  static constexpr nsLiteralCString Values[41] {
    "uint8"_ns,
    "uint8x2"_ns,
    "uint8x4"_ns,
    "sint8"_ns,
    "sint8x2"_ns,
    "sint8x4"_ns,
    "unorm8"_ns,
    "unorm8x2"_ns,
    "unorm8x4"_ns,
    "snorm8"_ns,
    "snorm8x2"_ns,
    "snorm8x4"_ns,
    "uint16"_ns,
    "uint16x2"_ns,
    "uint16x4"_ns,
    "sint16"_ns,
    "sint16x2"_ns,
    "sint16x4"_ns,
    "unorm16"_ns,
    "unorm16x2"_ns,
    "unorm16x4"_ns,
    "snorm16"_ns,
    "snorm16x2"_ns,
    "snorm16x4"_ns,
    "float16"_ns,
    "float16x2"_ns,
    "float16x4"_ns,
    "float32"_ns,
    "float32x2"_ns,
    "float32x3"_ns,
    "float32x4"_ns,
    "uint32"_ns,
    "uint32x2"_ns,
    "uint32x3"_ns,
    "uint32x4"_ns,
    "sint32"_ns,
    "sint32x2"_ns,
    "sint32x3"_ns,
    "sint32x4"_ns,
    "unorm10-10-10-2"_ns,
    "unorm8x4-bgra"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUVertexFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUVertexStepMode : uint8_t {
  Vertex,
  Instance,
};

namespace binding_detail {
template <> struct EnumStrings<GPUVertexStepMode> {
  static constexpr nsLiteralCString Values[2] {
    "vertex"_ns,
    "instance"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUVertexStepMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPULoadOp : uint8_t {
  Load,
  Clear,
};

namespace binding_detail {
template <> struct EnumStrings<GPULoadOp> {
  static constexpr nsLiteralCString Values[2] {
    "load"_ns,
    "clear"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPULoadOp aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStoreOp : uint8_t {
  Store,
  Discard,
};

namespace binding_detail {
template <> struct EnumStrings<GPUStoreOp> {
  static constexpr nsLiteralCString Values[2] {
    "store"_ns,
    "discard"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUStoreOp aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUQueryType : uint8_t {
  Occlusion,
  Timestamp,
};

namespace binding_detail {
template <> struct EnumStrings<GPUQueryType> {
  static constexpr nsLiteralCString Values[2] {
    "occlusion"_ns,
    "timestamp"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUQueryType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCanvasAlphaMode : uint8_t {
  Opaque,
  Premultiplied,
};

namespace binding_detail {
template <> struct EnumStrings<GPUCanvasAlphaMode> {
  static constexpr nsLiteralCString Values[2] {
    "opaque"_ns,
    "premultiplied"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUCanvasAlphaMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUDeviceLostReason : uint8_t {
  Destroyed,
};

namespace binding_detail {
template <> struct EnumStrings<GPUDeviceLostReason> {
  static constexpr nsLiteralCString Values[1] {
    "destroyed"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUDeviceLostReason aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUErrorFilter : uint8_t {
  Validation,
  Out_of_memory,
  Internal,
};

namespace binding_detail {
template <> struct EnumStrings<GPUErrorFilter> {
  static constexpr nsLiteralCString Values[3] {
    "validation"_ns,
    "out-of-memory"_ns,
    "internal"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, GPUErrorFilter aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aUnion);


void
ImplCycleCollectionUnlink(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion);


void
ImplCycleCollectionUnlink(OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas& aUnion);


struct GPUBlendComponent : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUBlendFactor mDstFactor;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendOperation mOperation;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendFactor mSrcFactor;

  GPUBlendComponent();

  explicit inline GPUBlendComponent(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBlendComponent(GPUBlendComponent&& aOther) = default;

  explicit inline GPUBlendComponent(const GPUBlendComponent& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBlendComponent&
  operator=(const GPUBlendComponent& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBlendComponentAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBlendComponent : public GPUBlendComponent
{
  inline FastGPUBlendComponent()
    : GPUBlendComponent(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferBinding : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Buffer> mBuffer;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mSize;

  GPUBufferBinding();

  explicit inline GPUBufferBinding(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBufferBinding(GPUBufferBinding&& aOther) = default;

  explicit inline GPUBufferBinding(const GPUBufferBinding& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBuffer, "mBuffer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBuffer);
  }

  GPUBufferBinding&
  operator=(const GPUBufferBinding& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBufferBindingAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferBinding : public GPUBufferBinding
{
  inline FastGPUBufferBinding()
    : GPUBufferBinding(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mHasDynamicOffset;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mMinBindingSize;
  MOZ_INIT_OUTSIDE_CTOR GPUBufferBindingType mType;

  GPUBufferBindingLayout();

  explicit inline GPUBufferBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBufferBindingLayout(GPUBufferBindingLayout&& aOther) = default;

  explicit inline GPUBufferBindingLayout(const GPUBufferBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBufferBindingLayout&
  operator=(const GPUBufferBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBufferBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferBindingLayout : public GPUBufferBindingLayout
{
  inline FastGPUBufferBindingLayout()
    : GPUBufferBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCanvasConfiguration : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCanvasAlphaMode mAlphaMode;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Device> mDevice;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUTextureFormat> mViewFormats;

  GPUCanvasConfiguration();

  explicit inline GPUCanvasConfiguration(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCanvasConfiguration(GPUCanvasConfiguration&& aOther) = default;

  explicit inline GPUCanvasConfiguration(const GPUCanvasConfiguration& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mDevice, "mDevice", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mDevice);
  }

  GPUCanvasConfiguration&
  operator=(const GPUCanvasConfiguration& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUCanvasConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUCanvasConfiguration : public GPUCanvasConfiguration
{
  inline FastGPUCanvasConfiguration()
    : GPUCanvasConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUColorDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mA;
  MOZ_INIT_OUTSIDE_CTOR double mB;
  MOZ_INIT_OUTSIDE_CTOR double mG;
  MOZ_INIT_OUTSIDE_CTOR double mR;

  GPUColorDict();

  explicit inline GPUColorDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUColorDict(GPUColorDict&& aOther) = default;

  explicit inline GPUColorDict(const GPUColorDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUColorDict&
  operator=(const GPUColorDict& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUColorDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUColorDict : public GPUColorDict
{
  inline FastGPUColorDict()
    : GPUColorDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUComputePassTimestampWrites : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mBeginningOfPassWriteIndex;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mEndOfPassWriteIndex;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::QuerySet> mQuerySet;

  GPUComputePassTimestampWrites();

  explicit inline GPUComputePassTimestampWrites(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUComputePassTimestampWrites(GPUComputePassTimestampWrites&& aOther) = default;

  explicit inline GPUComputePassTimestampWrites(const GPUComputePassTimestampWrites& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mQuerySet, "mQuerySet", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mQuerySet);
  }

  GPUComputePassTimestampWrites&
  operator=(const GPUComputePassTimestampWrites& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUComputePassTimestampWritesAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUComputePassTimestampWrites : public GPUComputePassTimestampWrites
{
  inline FastGPUComputePassTimestampWrites()
    : GPUComputePassTimestampWrites(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUExtent3DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mDepthOrArrayLayers;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  GPUExtent3DDict();

  explicit inline GPUExtent3DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUExtent3DDict(GPUExtent3DDict&& aOther) = default;

  explicit inline GPUExtent3DDict(const GPUExtent3DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUExtent3DDict&
  operator=(const GPUExtent3DDict& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUExtent3DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUExtent3DDict : public GPUExtent3DDict
{
  inline FastGPUExtent3DDict()
    : GPUExtent3DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUMultisampleState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAlphaToCoverageEnabled;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMask;

  GPUMultisampleState();

  explicit inline GPUMultisampleState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUMultisampleState(GPUMultisampleState&& aOther) = default;

  explicit inline GPUMultisampleState(const GPUMultisampleState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUMultisampleState&
  operator=(const GPUMultisampleState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUMultisampleStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUMultisampleState : public GPUMultisampleState
{
  inline FastGPUMultisampleState()
    : GPUMultisampleState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUObjectDescriptorBase : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mLabel;

  GPUObjectDescriptorBase();

  explicit inline GPUObjectDescriptorBase(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUObjectDescriptorBase(GPUObjectDescriptorBase&& aOther) = default;

  explicit inline GPUObjectDescriptorBase(const GPUObjectDescriptorBase& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUObjectDescriptorBase&
  operator=(const GPUObjectDescriptorBase& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUObjectDescriptorBaseAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUObjectDescriptorBase : public GPUObjectDescriptorBase
{
  inline FastGPUObjectDescriptorBase()
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUOrigin2DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mX;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mY;

  GPUOrigin2DDict();

  explicit inline GPUOrigin2DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUOrigin2DDict(GPUOrigin2DDict&& aOther) = default;

  explicit inline GPUOrigin2DDict(const GPUOrigin2DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUOrigin2DDict&
  operator=(const GPUOrigin2DDict& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUOrigin2DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUOrigin2DDict : public GPUOrigin2DDict
{
  inline FastGPUOrigin2DDict()
    : GPUOrigin2DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUOrigin3DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mX;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mY;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mZ;

  GPUOrigin3DDict();

  explicit inline GPUOrigin3DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUOrigin3DDict(GPUOrigin3DDict&& aOther) = default;

  explicit inline GPUOrigin3DDict(const GPUOrigin3DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUOrigin3DDict&
  operator=(const GPUOrigin3DDict& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUOrigin3DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUOrigin3DDict : public GPUOrigin3DDict
{
  inline FastGPUOrigin3DDict()
    : GPUOrigin3DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUPipelineErrorInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUPipelineErrorReason mReason;

  GPUPipelineErrorInit();

  explicit inline GPUPipelineErrorInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUPipelineErrorInit(GPUPipelineErrorInit&& aOther) = default;

  explicit inline GPUPipelineErrorInit(const GPUPipelineErrorInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUPipelineErrorInit&
  operator=(const GPUPipelineErrorInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPipelineErrorInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPipelineErrorInit : public GPUPipelineErrorInit
{
  inline FastGPUPipelineErrorInit()
    : GPUPipelineErrorInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPUPipelineLayoutOrGPUAutoLayoutMode : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUPipelineLayout,
    eGPUAutoLayoutMode
  };
public:
  enum class Type
  {
    eGPUPipelineLayout = TypeOrUninit::eGPUPipelineLayout,
    eGPUAutoLayoutMode = TypeOrUninit::eGPUAutoLayoutMode
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::webgpu::PipelineLayout> > mGPUPipelineLayout;
    UnionMember<GPUAutoLayoutMode > mGPUAutoLayoutMode;

  };

  TypeOrUninit mType;
  Value mValue;

  GPUPipelineLayoutOrGPUAutoLayoutMode(const GPUPipelineLayoutOrGPUAutoLayoutMode&) = delete;
  GPUPipelineLayoutOrGPUAutoLayoutMode& operator=(const GPUPipelineLayoutOrGPUAutoLayoutMode&) = delete;
public:
  explicit inline GPUPipelineLayoutOrGPUAutoLayoutMode()
    : mType(eUninitialized)
  {
  }

  inline ~GPUPipelineLayoutOrGPUAutoLayoutMode()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::webgpu::PipelineLayout>&
  RawSetAsGPUPipelineLayout()
  {
    if (mType == eGPUPipelineLayout) {
      return mValue.mGPUPipelineLayout.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUPipelineLayout;
    return mValue.mGPUPipelineLayout.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::webgpu::PipelineLayout>&
  SetAsGPUPipelineLayout()
  {
    if (mType == eGPUPipelineLayout) {
      return mValue.mGPUPipelineLayout.Value();
    }
    Uninit();
    mType = eGPUPipelineLayout;
    return mValue.mGPUPipelineLayout.SetValue();
  }

  inline bool
  IsGPUPipelineLayout() const
  {
    return mType == eGPUPipelineLayout;
  }

  inline NonNull<mozilla::webgpu::PipelineLayout>&
  GetAsGPUPipelineLayout()
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  inline mozilla::webgpu::PipelineLayout&
  GetAsGPUPipelineLayout() const
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  [[nodiscard]] inline GPUAutoLayoutMode&
  RawSetAsGPUAutoLayoutMode()
  {
    if (mType == eGPUAutoLayoutMode) {
      return mValue.mGPUAutoLayoutMode.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUAutoLayoutMode;
    return mValue.mGPUAutoLayoutMode.SetValue();
  }

  [[nodiscard]] inline GPUAutoLayoutMode&
  SetAsGPUAutoLayoutMode()
  {
    if (mType == eGPUAutoLayoutMode) {
      return mValue.mGPUAutoLayoutMode.Value();
    }
    Uninit();
    mType = eGPUAutoLayoutMode;
    return mValue.mGPUAutoLayoutMode.SetValue();
  }

  inline bool
  IsGPUAutoLayoutMode() const
  {
    return mType == eGPUAutoLayoutMode;
  }

  inline GPUAutoLayoutMode&
  GetAsGPUAutoLayoutMode()
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  inline GPUAutoLayoutMode
  GetAsGPUAutoLayoutMode() const
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPUPipelineLayout: {
        DestroyGPUPipelineLayout();
        break;
      }
      case eGPUAutoLayoutMode: {
        DestroyGPUAutoLayoutMode();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToGPUPipelineLayout(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUPipelineLayout(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUPipelineLayout()
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    mValue.mGPUPipelineLayout.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUAutoLayoutMode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUAutoLayoutMode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUAutoLayoutMode()
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    mValue.mGPUAutoLayoutMode.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPUPipelineLayoutOrGPUAutoLayoutMode : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUPipelineLayout,
    eGPUAutoLayoutMode
  };
public:
  enum class Type
  {
    eGPUPipelineLayout = TypeOrUninit::eGPUPipelineLayout,
    eGPUAutoLayoutMode = TypeOrUninit::eGPUAutoLayoutMode
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::webgpu::PipelineLayout> > mGPUPipelineLayout;
    UnionMember<GPUAutoLayoutMode > mGPUAutoLayoutMode;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningGPUPipelineLayoutOrGPUAutoLayoutMode()
    : mType(eUninitialized)
  {
  }

  OwningGPUPipelineLayoutOrGPUAutoLayoutMode(OwningGPUPipelineLayoutOrGPUAutoLayoutMode&& aOther);

  explicit inline OwningGPUPipelineLayoutOrGPUAutoLayoutMode(const OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPUPipelineLayoutOrGPUAutoLayoutMode()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::webgpu::PipelineLayout>&
  RawSetAsGPUPipelineLayout();

  [[nodiscard]] OwningNonNull<mozilla::webgpu::PipelineLayout>&
  SetAsGPUPipelineLayout();

  inline bool
  IsGPUPipelineLayout() const
  {
    return mType == eGPUPipelineLayout;
  }

  inline OwningNonNull<mozilla::webgpu::PipelineLayout>&
  GetAsGPUPipelineLayout()
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  inline OwningNonNull<mozilla::webgpu::PipelineLayout> const &
  GetAsGPUPipelineLayout() const
  {
    MOZ_RELEASE_ASSERT(IsGPUPipelineLayout(), "Wrong type!");
    return mValue.mGPUPipelineLayout.Value();
  }

  [[nodiscard]] GPUAutoLayoutMode&
  RawSetAsGPUAutoLayoutMode();

  [[nodiscard]] GPUAutoLayoutMode&
  SetAsGPUAutoLayoutMode();

  inline bool
  IsGPUAutoLayoutMode() const
  {
    return mType == eGPUAutoLayoutMode;
  }

  inline GPUAutoLayoutMode&
  GetAsGPUAutoLayoutMode()
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  inline GPUAutoLayoutMode const &
  GetAsGPUAutoLayoutMode() const
  {
    MOZ_RELEASE_ASSERT(IsGPUAutoLayoutMode(), "Wrong type!");
    return mValue.mGPUAutoLayoutMode.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningGPUPipelineLayoutOrGPUAutoLayoutMode&
  operator=(OwningGPUPipelineLayoutOrGPUAutoLayoutMode&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningGPUPipelineLayoutOrGPUAutoLayoutMode&
  operator=(const OwningGPUPipelineLayoutOrGPUAutoLayoutMode& aOther);

private:
  bool
  TrySetToGPUPipelineLayout(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUPipelineLayout(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUPipelineLayout();

  bool
  TrySetToGPUAutoLayoutMode(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUAutoLayoutMode(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUAutoLayoutMode();
};


struct GPUPrimitiveState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCullMode mCullMode;
  MOZ_INIT_OUTSIDE_CTOR GPUFrontFace mFrontFace;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUIndexFormat> mStripIndexFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUPrimitiveTopology mTopology;
  MOZ_INIT_OUTSIDE_CTOR bool mUnclippedDepth;

  GPUPrimitiveState();

  explicit inline GPUPrimitiveState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUPrimitiveState(GPUPrimitiveState&& aOther) = default;

  explicit inline GPUPrimitiveState(const GPUPrimitiveState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUPrimitiveState&
  operator=(const GPUPrimitiveState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPrimitiveStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPrimitiveState : public GPUPrimitiveState
{
  inline FastGPUPrimitiveState()
    : GPUPrimitiveState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUProgrammableStage : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Record<nsString, double>> mConstants;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mEntryPoint;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::ShaderModule> mModule;

  GPUProgrammableStage();

  explicit inline GPUProgrammableStage(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUProgrammableStage(GPUProgrammableStage&& aOther) = default;

private:
  GPUProgrammableStage(const GPUProgrammableStage&) = delete;
  GPUProgrammableStage& operator=(const GPUProgrammableStage&) = delete;

  static bool
  InitIds(JSContext* cx, GPUProgrammableStageAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mModule, "mModule", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mModule);
  }
};

namespace binding_detail {
struct FastGPUProgrammableStage : public GPUProgrammableStage
{
  inline FastGPUProgrammableStage()
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassDepthStencilAttachment : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<float> mDepthClearValue;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPULoadOp> mDepthLoadOp;
  MOZ_INIT_OUTSIDE_CTOR bool mDepthReadOnly;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUStoreOp> mDepthStoreOp;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilClearValue;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPULoadOp> mStencilLoadOp;
  MOZ_INIT_OUTSIDE_CTOR bool mStencilReadOnly;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUStoreOp> mStencilStoreOp;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::TextureView> mView;

  GPURenderPassDepthStencilAttachment();

  explicit inline GPURenderPassDepthStencilAttachment(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassDepthStencilAttachment(GPURenderPassDepthStencilAttachment&& aOther) = default;

  explicit inline GPURenderPassDepthStencilAttachment(const GPURenderPassDepthStencilAttachment& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mView, "mView", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mView);
  }

  GPURenderPassDepthStencilAttachment&
  operator=(const GPURenderPassDepthStencilAttachment& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassDepthStencilAttachmentAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassDepthStencilAttachment : public GPURenderPassDepthStencilAttachment
{
  inline FastGPURenderPassDepthStencilAttachment()
    : GPURenderPassDepthStencilAttachment(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassTimestampWrites : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mBeginningOfPassWriteIndex;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mEndOfPassWriteIndex;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::QuerySet> mQuerySet;

  GPURenderPassTimestampWrites();

  explicit inline GPURenderPassTimestampWrites(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassTimestampWrites(GPURenderPassTimestampWrites&& aOther) = default;

  explicit inline GPURenderPassTimestampWrites(const GPURenderPassTimestampWrites& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mQuerySet, "mQuerySet", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mQuerySet);
  }

  GPURenderPassTimestampWrites&
  operator=(const GPURenderPassTimestampWrites& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassTimestampWritesAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassTimestampWrites : public GPURenderPassTimestampWrites
{
  inline FastGPURenderPassTimestampWrites()
    : GPURenderPassTimestampWrites(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURequestAdapterOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mFeatureLevel;
  MOZ_INIT_OUTSIDE_CTOR bool mForceFallbackAdapter;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUPowerPreference> mPowerPreference;
  MOZ_INIT_OUTSIDE_CTOR bool mXrCompatible;

  GPURequestAdapterOptions();

  explicit inline GPURequestAdapterOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURequestAdapterOptions(GPURequestAdapterOptions&& aOther) = default;

  explicit inline GPURequestAdapterOptions(const GPURequestAdapterOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURequestAdapterOptions&
  operator=(const GPURequestAdapterOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURequestAdapterOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURequestAdapterOptions : public GPURequestAdapterOptions
{
  inline FastGPURequestAdapterOptions()
    : GPURequestAdapterOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUSamplerBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUSamplerBindingType mType;

  GPUSamplerBindingLayout();

  explicit inline GPUSamplerBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUSamplerBindingLayout(GPUSamplerBindingLayout&& aOther) = default;

  explicit inline GPUSamplerBindingLayout(const GPUSamplerBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUSamplerBindingLayout&
  operator=(const GPUSamplerBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUSamplerBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUSamplerBindingLayout : public GPUSamplerBindingLayout
{
  inline FastGPUSamplerBindingLayout()
    : GPUSamplerBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUStencilFaceState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCompareFunction mCompare;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mDepthFailOp;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mFailOp;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mPassOp;

  GPUStencilFaceState();

  explicit inline GPUStencilFaceState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUStencilFaceState(GPUStencilFaceState&& aOther) = default;

  explicit inline GPUStencilFaceState(const GPUStencilFaceState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUStencilFaceState&
  operator=(const GPUStencilFaceState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUStencilFaceStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUStencilFaceState : public GPUStencilFaceState
{
  inline FastGPUStencilFaceState()
    : GPUStencilFaceState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUStorageTextureBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUStorageTextureAccess mAccess;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureViewDimension mViewDimension;

  GPUStorageTextureBindingLayout();

  explicit inline GPUStorageTextureBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUStorageTextureBindingLayout(GPUStorageTextureBindingLayout&& aOther) = default;

  explicit inline GPUStorageTextureBindingLayout(const GPUStorageTextureBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUStorageTextureBindingLayout&
  operator=(const GPUStorageTextureBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUStorageTextureBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUStorageTextureBindingLayout : public GPUStorageTextureBindingLayout
{
  inline FastGPUStorageTextureBindingLayout()
    : GPUStorageTextureBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTexelCopyBufferLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mBytesPerRow;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mRowsPerImage;

  GPUTexelCopyBufferLayout();

  explicit inline GPUTexelCopyBufferLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTexelCopyBufferLayout(GPUTexelCopyBufferLayout&& aOther) = default;

  explicit inline GPUTexelCopyBufferLayout(const GPUTexelCopyBufferLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTexelCopyBufferLayout&
  operator=(const GPUTexelCopyBufferLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTexelCopyBufferLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTexelCopyBufferLayout : public GPUTexelCopyBufferLayout
{
  inline FastGPUTexelCopyBufferLayout()
    : GPUTexelCopyBufferLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureBindingLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mMultisampled;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureSampleType mSampleType;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureViewDimension mViewDimension;

  GPUTextureBindingLayout();

  explicit inline GPUTextureBindingLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTextureBindingLayout(GPUTextureBindingLayout&& aOther) = default;

  explicit inline GPUTextureBindingLayout(const GPUTextureBindingLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureBindingLayout&
  operator=(const GPUTextureBindingLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureBindingLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureBindingLayout : public GPUTextureBindingLayout
{
  inline FastGPUTextureBindingLayout()
    : GPUTextureBindingLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexAttribute : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUVertexFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mShaderLocation;

  GPUVertexAttribute();

  explicit inline GPUVertexAttribute(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUVertexAttribute(GPUVertexAttribute&& aOther) = default;

  explicit inline GPUVertexAttribute(const GPUVertexAttribute& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUVertexAttribute&
  operator=(const GPUVertexAttribute& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexAttributeAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexAttribute : public GPUVertexAttribute
{
  inline FastGPUVertexAttribute()
    : GPUVertexAttribute(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eImageBitmap,
    eHTMLImageElement,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<NonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<NonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<NonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

  ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas(const ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas&) = delete;
  ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas& operator=(const ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas&) = delete;
public:
  explicit inline ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  inline ~ImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap()
  {
    if (mType == eImageBitmap) {
      return mValue.mImageBitmap.Value();
    }
    Uninit();
    mType = eImageBitmap;
    return mValue.mImageBitmap.SetValue();
  }

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline NonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline mozilla::dom::ImageBitmap&
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement()
  {
    if (mType == eHTMLImageElement) {
      return mValue.mHTMLImageElement.Value();
    }
    Uninit();
    mType = eHTMLImageElement;
    return mValue.mHTMLImageElement.SetValue();
  }

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline NonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline mozilla::dom::HTMLImageElement&
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement()
  {
    if (mType == eHTMLCanvasElement) {
      return mValue.mHTMLCanvasElement.Value();
    }
    Uninit();
    mType = eHTMLCanvasElement;
    return mValue.mHTMLCanvasElement.SetValue();
  }

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline NonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline mozilla::dom::HTMLCanvasElement&
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas()
  {
    if (mType == eOffscreenCanvas) {
      return mValue.mOffscreenCanvas.Value();
    }
    Uninit();
    mType = eOffscreenCanvas;
    return mValue.mOffscreenCanvas.SetValue();
  }

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline NonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline mozilla::dom::OffscreenCanvas&
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eImageBitmap: {
        DestroyImageBitmap();
        break;
      }
      case eHTMLImageElement: {
        DestroyHTMLImageElement();
        break;
      }
      case eHTMLCanvasElement: {
        DestroyHTMLCanvasElement();
        break;
      }
      case eOffscreenCanvas: {
        DestroyOffscreenCanvas();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    mValue.mImageBitmap.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    mValue.mHTMLImageElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    mValue.mHTMLCanvasElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    mValue.mOffscreenCanvas.Destroy();
    mType = eUninitialized;
  }
};


class OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eImageBitmap,
    eHTMLImageElement,
    eHTMLCanvasElement,
    eOffscreenCanvas
  };
public:
  enum class Type
  {
    eImageBitmap = TypeOrUninit::eImageBitmap,
    eHTMLImageElement = TypeOrUninit::eHTMLImageElement,
    eHTMLCanvasElement = TypeOrUninit::eHTMLCanvasElement,
    eOffscreenCanvas = TypeOrUninit::eOffscreenCanvas
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::ImageBitmap> > mImageBitmap;
    UnionMember<OwningNonNull<mozilla::dom::HTMLImageElement> > mHTMLImageElement;
    UnionMember<OwningNonNull<mozilla::dom::HTMLCanvasElement> > mHTMLCanvasElement;
    UnionMember<OwningNonNull<mozilla::dom::OffscreenCanvas> > mOffscreenCanvas;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas()
    : mType(eUninitialized)
  {
  }

  OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas(OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas&& aOther);

  explicit inline OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas(const OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::ImageBitmap>&
  RawSetAsImageBitmap();

  [[nodiscard]] OwningNonNull<mozilla::dom::ImageBitmap>&
  SetAsImageBitmap();

  inline bool
  IsImageBitmap() const
  {
    return mType == eImageBitmap;
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap>&
  GetAsImageBitmap()
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  inline OwningNonNull<mozilla::dom::ImageBitmap> const &
  GetAsImageBitmap() const
  {
    MOZ_RELEASE_ASSERT(IsImageBitmap(), "Wrong type!");
    return mValue.mImageBitmap.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLImageElement>&
  RawSetAsHTMLImageElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLImageElement>&
  SetAsHTMLImageElement();

  inline bool
  IsHTMLImageElement() const
  {
    return mType == eHTMLImageElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement>&
  GetAsHTMLImageElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLImageElement> const &
  GetAsHTMLImageElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLImageElement(), "Wrong type!");
    return mValue.mHTMLImageElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  RawSetAsHTMLCanvasElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  SetAsHTMLCanvasElement();

  inline bool
  IsHTMLCanvasElement() const
  {
    return mType == eHTMLCanvasElement;
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement>&
  GetAsHTMLCanvasElement()
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  inline OwningNonNull<mozilla::dom::HTMLCanvasElement> const &
  GetAsHTMLCanvasElement() const
  {
    MOZ_RELEASE_ASSERT(IsHTMLCanvasElement(), "Wrong type!");
    return mValue.mHTMLCanvasElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  RawSetAsOffscreenCanvas();

  [[nodiscard]] OwningNonNull<mozilla::dom::OffscreenCanvas>&
  SetAsOffscreenCanvas();

  inline bool
  IsOffscreenCanvas() const
  {
    return mType == eOffscreenCanvas;
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas>&
  GetAsOffscreenCanvas()
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  inline OwningNonNull<mozilla::dom::OffscreenCanvas> const &
  GetAsOffscreenCanvas() const
  {
    MOZ_RELEASE_ASSERT(IsOffscreenCanvas(), "Wrong type!");
    return mValue.mOffscreenCanvas.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas&
  operator=(OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas&
  operator=(const OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas& aOther);

private:
  bool
  TrySetToImageBitmap(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToImageBitmap(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyImageBitmap();

  bool
  TrySetToHTMLImageElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLImageElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLImageElement();

  bool
  TrySetToHTMLCanvasElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToHTMLCanvasElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyHTMLCanvasElement();

  bool
  TrySetToOffscreenCanvas(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToOffscreenCanvas(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyOffscreenCanvas();
};


class DoubleSequenceOrGPUColorDict : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDoubleSequence,
    eGPUColorDict
  };
public:
  enum class Type
  {
    eDoubleSequence = TypeOrUninit::eDoubleSequence,
    eGPUColorDict = TypeOrUninit::eGPUColorDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<double> > mDoubleSequence;
    UnionMember<binding_detail::FastGPUColorDict > mGPUColorDict;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleSequenceOrGPUColorDict(const DoubleSequenceOrGPUColorDict&) = delete;
  DoubleSequenceOrGPUColorDict& operator=(const DoubleSequenceOrGPUColorDict&) = delete;
public:
  explicit inline DoubleSequenceOrGPUColorDict()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleSequenceOrGPUColorDict()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<double>&
  RawSetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<double>&
  SetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    Uninit();
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline binding_detail::AutoSequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline const Sequence<double>&
  GetAsDoubleSequence() const
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  [[nodiscard]] inline binding_detail::FastGPUColorDict&
  RawSetAsGPUColorDict()
  {
    if (mType == eGPUColorDict) {
      return mValue.mGPUColorDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUColorDict;
    return mValue.mGPUColorDict.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastGPUColorDict&
  SetAsGPUColorDict()
  {
    if (mType == eGPUColorDict) {
      return mValue.mGPUColorDict.Value();
    }
    Uninit();
    mType = eGPUColorDict;
    return mValue.mGPUColorDict.SetValue();
  }

  inline bool
  IsGPUColorDict() const
  {
    return mType == eGPUColorDict;
  }

  inline binding_detail::FastGPUColorDict&
  GetAsGPUColorDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  inline const GPUColorDict&
  GetAsGPUColorDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDoubleSequence: {
        DestroyDoubleSequence();
        break;
      }
      case eGPUColorDict: {
        DestroyGPUColorDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToDoubleSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    mValue.mDoubleSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUColorDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUColorDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUColorDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    mValue.mGPUColorDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningDoubleSequenceOrGPUColorDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDoubleSequence,
    eGPUColorDict
  };
public:
  enum class Type
  {
    eDoubleSequence = TypeOrUninit::eDoubleSequence,
    eGPUColorDict = TypeOrUninit::eGPUColorDict
  };

private:
  union Value
  {
    UnionMember<Sequence<double> > mDoubleSequence;
    UnionMember<GPUColorDict > mGPUColorDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleSequenceOrGPUColorDict()
    : mType(eUninitialized)
  {
  }

  OwningDoubleSequenceOrGPUColorDict(OwningDoubleSequenceOrGPUColorDict&& aOther);

  explicit inline OwningDoubleSequenceOrGPUColorDict(const OwningDoubleSequenceOrGPUColorDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleSequenceOrGPUColorDict()
  {
    Uninit();
  }

  [[nodiscard]] Sequence<double>&
  RawSetAsDoubleSequence();

  [[nodiscard]] Sequence<double>&
  SetAsDoubleSequence();

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline Sequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline Sequence<double> const &
  GetAsDoubleSequence() const
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  [[nodiscard]] GPUColorDict&
  RawSetAsGPUColorDict();

  [[nodiscard]] GPUColorDict&
  SetAsGPUColorDict();

  inline bool
  IsGPUColorDict() const
  {
    return mType == eGPUColorDict;
  }

  inline GPUColorDict&
  GetAsGPUColorDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  inline GPUColorDict const &
  GetAsGPUColorDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningDoubleSequenceOrGPUColorDict&
  operator=(OwningDoubleSequenceOrGPUColorDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleSequenceOrGPUColorDict&
  operator=(const OwningDoubleSequenceOrGPUColorDict& aOther);

private:
  bool
  TrySetToDoubleSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDoubleSequence();

  bool
  TrySetToGPUColorDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUColorDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUColorDict();
};


struct GPUBindGroupLayoutEntry : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBinding;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUBufferBindingLayout> mBuffer;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUSamplerBindingLayout> mSampler;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUStorageTextureBindingLayout> mStorageTexture;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureBindingLayout> mTexture;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mVisibility;

  GPUBindGroupLayoutEntry();

  explicit inline GPUBindGroupLayoutEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupLayoutEntry(GPUBindGroupLayoutEntry&& aOther) = default;

  explicit inline GPUBindGroupLayoutEntry(const GPUBindGroupLayoutEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBindGroupLayoutEntry&
  operator=(const GPUBindGroupLayoutEntry& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupLayoutEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupLayoutEntry : public GPUBindGroupLayoutEntry
{
  inline FastGPUBindGroupLayoutEntry()
    : GPUBindGroupLayoutEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBlendState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUBlendComponent mAlpha;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendComponent mColor;

  GPUBlendState();

  explicit inline GPUBlendState(const FastDictionaryInitializer& )
    : mAlpha(FastDictionaryInitializer()),
      mColor(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBlendState(GPUBlendState&& aOther) = default;

  explicit inline GPUBlendState(const GPUBlendState& aOther)
    : mAlpha(FastDictionaryInitializer()),
      mColor(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBlendState&
  operator=(const GPUBlendState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBlendStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBlendState : public GPUBlendState
{
  inline FastGPUBlendState()
    : GPUBlendState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mMappedAtCreation;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mSize;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;

  GPUBufferDescriptor();

  explicit inline GPUBufferDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBufferDescriptor(GPUBufferDescriptor&& aOther) = default;

  explicit inline GPUBufferDescriptor(const GPUBufferDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBufferDescriptor&
  operator=(const GPUBufferDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBufferDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferDescriptor : public GPUBufferDescriptor
{
  inline FastGPUBufferDescriptor()
    : GPUBufferDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCommandBufferDescriptor : public GPUObjectDescriptorBase
{
  GPUCommandBufferDescriptor();

  explicit inline GPUCommandBufferDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCommandBufferDescriptor(GPUCommandBufferDescriptor&& aOther) = default;

  explicit inline GPUCommandBufferDescriptor(const GPUCommandBufferDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUCommandBufferDescriptor&
  operator=(const GPUCommandBufferDescriptor& aOther);
};

namespace binding_detail {
struct FastGPUCommandBufferDescriptor : public GPUCommandBufferDescriptor
{
  inline FastGPUCommandBufferDescriptor()
    : GPUCommandBufferDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCommandEncoderDescriptor : public GPUObjectDescriptorBase
{
  GPUCommandEncoderDescriptor();

  explicit inline GPUCommandEncoderDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCommandEncoderDescriptor(GPUCommandEncoderDescriptor&& aOther) = default;

  explicit inline GPUCommandEncoderDescriptor(const GPUCommandEncoderDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUCommandEncoderDescriptor&
  operator=(const GPUCommandEncoderDescriptor& aOther);
};

namespace binding_detail {
struct FastGPUCommandEncoderDescriptor : public GPUCommandEncoderDescriptor
{
  inline FastGPUCommandEncoderDescriptor()
    : GPUCommandEncoderDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUComputePassDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUComputePassTimestampWrites> mTimestampWrites;

  GPUComputePassDescriptor();

  explicit inline GPUComputePassDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUComputePassDescriptor(GPUComputePassDescriptor&& aOther) = default;

  explicit inline GPUComputePassDescriptor(const GPUComputePassDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mTimestampWrites, "mTimestampWrites", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mTimestampWrites);
  }

  GPUComputePassDescriptor&
  operator=(const GPUComputePassDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUComputePassDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUComputePassDescriptor : public GPUComputePassDescriptor
{
  inline FastGPUComputePassDescriptor()
    : GPUComputePassDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUDepthStencilState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR int32_t mDepthBias;
  MOZ_INIT_OUTSIDE_CTOR float mDepthBiasClamp;
  MOZ_INIT_OUTSIDE_CTOR float mDepthBiasSlopeScale;
  MOZ_INIT_OUTSIDE_CTOR GPUCompareFunction mDepthCompare;
  MOZ_INIT_OUTSIDE_CTOR bool mDepthWriteEnabled;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilFaceState mStencilBack;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilFaceState mStencilFront;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilReadMask;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilWriteMask;

  GPUDepthStencilState();

  explicit inline GPUDepthStencilState(const FastDictionaryInitializer& )
    : mStencilBack(FastDictionaryInitializer()),
      mStencilFront(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUDepthStencilState(GPUDepthStencilState&& aOther) = default;

  explicit inline GPUDepthStencilState(const GPUDepthStencilState& aOther)
    : mStencilBack(FastDictionaryInitializer()),
      mStencilFront(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUDepthStencilState&
  operator=(const GPUDepthStencilState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUDepthStencilStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUDepthStencilState : public GPUDepthStencilState
{
  inline FastGPUDepthStencilState()
    : GPUDepthStencilState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUPipelineDescriptorBase : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningGPUPipelineLayoutOrGPUAutoLayoutMode mLayout;

  GPUPipelineDescriptorBase();

  explicit inline GPUPipelineDescriptorBase(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUPipelineDescriptorBase(GPUPipelineDescriptorBase&& aOther) = default;

  explicit inline GPUPipelineDescriptorBase(const GPUPipelineDescriptorBase& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mLayout, "mLayout", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mLayout);
  }

  GPUPipelineDescriptorBase&
  operator=(const GPUPipelineDescriptorBase& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPipelineDescriptorBaseAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPipelineDescriptorBase : public GPUPipelineDescriptorBase
{
  inline FastGPUPipelineDescriptorBase()
    : GPUPipelineDescriptorBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUPipelineLayoutDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::webgpu::BindGroupLayout>> mBindGroupLayouts;

  GPUPipelineLayoutDescriptor();

  explicit inline GPUPipelineLayoutDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUPipelineLayoutDescriptor(GPUPipelineLayoutDescriptor&& aOther) = default;

  explicit inline GPUPipelineLayoutDescriptor(const GPUPipelineLayoutDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBindGroupLayouts, "mBindGroupLayouts", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBindGroupLayouts);
  }

  GPUPipelineLayoutDescriptor&
  operator=(const GPUPipelineLayoutDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPipelineLayoutDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPipelineLayoutDescriptor : public GPUPipelineLayoutDescriptor
{
  inline FastGPUPipelineLayoutDescriptor()
    : GPUPipelineLayoutDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUQuerySetDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCount;
  MOZ_INIT_OUTSIDE_CTOR GPUQueryType mType;

  GPUQuerySetDescriptor();

  explicit inline GPUQuerySetDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUQuerySetDescriptor(GPUQuerySetDescriptor&& aOther) = default;

  explicit inline GPUQuerySetDescriptor(const GPUQuerySetDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUQuerySetDescriptor&
  operator=(const GPUQuerySetDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUQuerySetDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUQuerySetDescriptor : public GPUQuerySetDescriptor
{
  inline FastGPUQuerySetDescriptor()
    : GPUQuerySetDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUQueueDescriptor : public GPUObjectDescriptorBase
{
  GPUQueueDescriptor();

  explicit inline GPUQueueDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUQueueDescriptor(GPUQueueDescriptor&& aOther) = default;

  explicit inline GPUQueueDescriptor(const GPUQueueDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUQueueDescriptor&
  operator=(const GPUQueueDescriptor& aOther);
};

namespace binding_detail {
struct FastGPUQueueDescriptor : public GPUQueueDescriptor
{
  inline FastGPUQueueDescriptor()
    : GPUQueueDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderBundleDescriptor : public GPUObjectDescriptorBase
{
  GPURenderBundleDescriptor();

  explicit inline GPURenderBundleDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderBundleDescriptor(GPURenderBundleDescriptor&& aOther) = default;

  explicit inline GPURenderBundleDescriptor(const GPURenderBundleDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderBundleDescriptor&
  operator=(const GPURenderBundleDescriptor& aOther);
};

namespace binding_detail {
struct FastGPURenderBundleDescriptor : public GPURenderBundleDescriptor
{
  inline FastGPURenderBundleDescriptor()
    : GPURenderBundleDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassLayout : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUTextureFormat> mColorFormats;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureFormat> mDepthStencilFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleCount;

  GPURenderPassLayout();

  explicit inline GPURenderPassLayout(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassLayout(GPURenderPassLayout&& aOther) = default;

  explicit inline GPURenderPassLayout(const GPURenderPassLayout& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderPassLayout&
  operator=(const GPURenderPassLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassLayout : public GPURenderPassLayout
{
  inline FastGPURenderPassLayout()
    : GPURenderPassLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUSamplerDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeU;
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeV;
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeW;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUCompareFunction> mCompare;
  MOZ_INIT_OUTSIDE_CTOR float mLodMaxClamp;
  MOZ_INIT_OUTSIDE_CTOR float mLodMinClamp;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMagFilter;
  MOZ_INIT_OUTSIDE_CTOR uint16_t mMaxAnisotropy;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMinFilter;
  MOZ_INIT_OUTSIDE_CTOR GPUMipmapFilterMode mMipmapFilter;

  GPUSamplerDescriptor();

  explicit inline GPUSamplerDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUSamplerDescriptor(GPUSamplerDescriptor&& aOther) = default;

  explicit inline GPUSamplerDescriptor(const GPUSamplerDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUSamplerDescriptor&
  operator=(const GPUSamplerDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUSamplerDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUSamplerDescriptor : public GPUSamplerDescriptor
{
  inline FastGPUSamplerDescriptor()
    : GPUSamplerDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPUSamplerOrGPUTextureViewOrGPUBufferBinding : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUSampler,
    eGPUTextureView,
    eGPUBufferBinding
  };
public:
  enum class Type
  {
    eGPUSampler = TypeOrUninit::eGPUSampler,
    eGPUTextureView = TypeOrUninit::eGPUTextureView,
    eGPUBufferBinding = TypeOrUninit::eGPUBufferBinding
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::webgpu::Sampler> > mGPUSampler;
    UnionMember<NonNull<mozilla::webgpu::TextureView> > mGPUTextureView;
    UnionMember<binding_detail::FastGPUBufferBinding > mGPUBufferBinding;

  };

  TypeOrUninit mType;
  Value mValue;

  GPUSamplerOrGPUTextureViewOrGPUBufferBinding(const GPUSamplerOrGPUTextureViewOrGPUBufferBinding&) = delete;
  GPUSamplerOrGPUTextureViewOrGPUBufferBinding& operator=(const GPUSamplerOrGPUTextureViewOrGPUBufferBinding&) = delete;
public:
  explicit inline GPUSamplerOrGPUTextureViewOrGPUBufferBinding()
    : mType(eUninitialized)
  {
  }

  inline ~GPUSamplerOrGPUTextureViewOrGPUBufferBinding()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::webgpu::Sampler>&
  RawSetAsGPUSampler()
  {
    if (mType == eGPUSampler) {
      return mValue.mGPUSampler.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUSampler;
    return mValue.mGPUSampler.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::webgpu::Sampler>&
  SetAsGPUSampler()
  {
    if (mType == eGPUSampler) {
      return mValue.mGPUSampler.Value();
    }
    Uninit();
    mType = eGPUSampler;
    return mValue.mGPUSampler.SetValue();
  }

  inline bool
  IsGPUSampler() const
  {
    return mType == eGPUSampler;
  }

  inline NonNull<mozilla::webgpu::Sampler>&
  GetAsGPUSampler()
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline mozilla::webgpu::Sampler&
  GetAsGPUSampler() const
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::webgpu::TextureView>&
  RawSetAsGPUTextureView()
  {
    if (mType == eGPUTextureView) {
      return mValue.mGPUTextureView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUTextureView;
    return mValue.mGPUTextureView.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::webgpu::TextureView>&
  SetAsGPUTextureView()
  {
    if (mType == eGPUTextureView) {
      return mValue.mGPUTextureView.Value();
    }
    Uninit();
    mType = eGPUTextureView;
    return mValue.mGPUTextureView.SetValue();
  }

  inline bool
  IsGPUTextureView() const
  {
    return mType == eGPUTextureView;
  }

  inline NonNull<mozilla::webgpu::TextureView>&
  GetAsGPUTextureView()
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline mozilla::webgpu::TextureView&
  GetAsGPUTextureView() const
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  [[nodiscard]] inline binding_detail::FastGPUBufferBinding&
  RawSetAsGPUBufferBinding()
  {
    if (mType == eGPUBufferBinding) {
      return mValue.mGPUBufferBinding.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUBufferBinding;
    return mValue.mGPUBufferBinding.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastGPUBufferBinding&
  SetAsGPUBufferBinding()
  {
    if (mType == eGPUBufferBinding) {
      return mValue.mGPUBufferBinding.Value();
    }
    Uninit();
    mType = eGPUBufferBinding;
    return mValue.mGPUBufferBinding.SetValue();
  }

  inline bool
  IsGPUBufferBinding() const
  {
    return mType == eGPUBufferBinding;
  }

  inline binding_detail::FastGPUBufferBinding&
  GetAsGPUBufferBinding()
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  inline const GPUBufferBinding&
  GetAsGPUBufferBinding() const
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPUSampler: {
        DestroyGPUSampler();
        break;
      }
      case eGPUTextureView: {
        DestroyGPUTextureView();
        break;
      }
      case eGPUBufferBinding: {
        DestroyGPUBufferBinding();
        break;
      }
    }
  }

private:
  bool
  TrySetToGPUSampler(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUSampler(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUSampler()
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    mValue.mGPUSampler.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUTextureView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUTextureView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUTextureView()
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    mValue.mGPUTextureView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUBufferBinding(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUBufferBinding(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUBufferBinding()
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    mValue.mGPUBufferBinding.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eGPUSampler,
    eGPUTextureView,
    eGPUBufferBinding
  };
public:
  enum class Type
  {
    eGPUSampler = TypeOrUninit::eGPUSampler,
    eGPUTextureView = TypeOrUninit::eGPUTextureView,
    eGPUBufferBinding = TypeOrUninit::eGPUBufferBinding
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::webgpu::Sampler> > mGPUSampler;
    UnionMember<OwningNonNull<mozilla::webgpu::TextureView> > mGPUTextureView;
    UnionMember<GPUBufferBinding > mGPUBufferBinding;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding()
    : mType(eUninitialized)
  {
  }

  OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&& aOther);

  explicit inline OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding(const OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::webgpu::Sampler>&
  RawSetAsGPUSampler();

  [[nodiscard]] OwningNonNull<mozilla::webgpu::Sampler>&
  SetAsGPUSampler();

  inline bool
  IsGPUSampler() const
  {
    return mType == eGPUSampler;
  }

  inline OwningNonNull<mozilla::webgpu::Sampler>&
  GetAsGPUSampler()
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline OwningNonNull<mozilla::webgpu::Sampler> const &
  GetAsGPUSampler() const
  {
    MOZ_RELEASE_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::webgpu::TextureView>&
  RawSetAsGPUTextureView();

  [[nodiscard]] OwningNonNull<mozilla::webgpu::TextureView>&
  SetAsGPUTextureView();

  inline bool
  IsGPUTextureView() const
  {
    return mType == eGPUTextureView;
  }

  inline OwningNonNull<mozilla::webgpu::TextureView>&
  GetAsGPUTextureView()
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline OwningNonNull<mozilla::webgpu::TextureView> const &
  GetAsGPUTextureView() const
  {
    MOZ_RELEASE_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  [[nodiscard]] GPUBufferBinding&
  RawSetAsGPUBufferBinding();

  [[nodiscard]] GPUBufferBinding&
  SetAsGPUBufferBinding();

  inline bool
  IsGPUBufferBinding() const
  {
    return mType == eGPUBufferBinding;
  }

  inline GPUBufferBinding&
  GetAsGPUBufferBinding()
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  inline GPUBufferBinding const &
  GetAsGPUBufferBinding() const
  {
    MOZ_RELEASE_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&
  operator=(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&
  operator=(const OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aOther);

private:
  bool
  TrySetToGPUSampler(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUSampler(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUSampler();

  bool
  TrySetToGPUTextureView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUTextureView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUTextureView();

  bool
  TrySetToGPUBufferBinding(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUBufferBinding(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUBufferBinding();
};


struct GPUShaderModuleCompilationHint : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mEntryPoint;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningGPUPipelineLayoutOrGPUAutoLayoutMode> mLayout;

  GPUShaderModuleCompilationHint();

  explicit inline GPUShaderModuleCompilationHint(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUShaderModuleCompilationHint(GPUShaderModuleCompilationHint&& aOther) = default;

  explicit inline GPUShaderModuleCompilationHint(const GPUShaderModuleCompilationHint& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mLayout, "mLayout", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mLayout);
  }

  GPUShaderModuleCompilationHint&
  operator=(const GPUShaderModuleCompilationHint& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUShaderModuleCompilationHintAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUShaderModuleCompilationHint : public GPUShaderModuleCompilationHint
{
  inline FastGPUShaderModuleCompilationHint()
    : GPUShaderModuleCompilationHint(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTexelCopyBufferInfo : public GPUTexelCopyBufferLayout
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Buffer> mBuffer;

  GPUTexelCopyBufferInfo();

  explicit inline GPUTexelCopyBufferInfo(const FastDictionaryInitializer& )
    : GPUTexelCopyBufferLayout(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTexelCopyBufferInfo(GPUTexelCopyBufferInfo&& aOther) = default;

  explicit inline GPUTexelCopyBufferInfo(const GPUTexelCopyBufferInfo& aOther)
    : GPUTexelCopyBufferLayout(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBuffer, "mBuffer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBuffer);
  }

  GPUTexelCopyBufferInfo&
  operator=(const GPUTexelCopyBufferInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTexelCopyBufferInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTexelCopyBufferInfo : public GPUTexelCopyBufferInfo
{
  inline FastGPUTexelCopyBufferInfo()
    : GPUTexelCopyBufferInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureViewDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mArrayLayerCount;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureAspect mAspect;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBaseArrayLayer;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBaseMipLevel;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureViewDimension> mDimension;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureFormat> mFormat;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mMipLevelCount;

  GPUTextureViewDescriptor();

  explicit inline GPUTextureViewDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTextureViewDescriptor(GPUTextureViewDescriptor&& aOther) = default;

  explicit inline GPUTextureViewDescriptor(const GPUTextureViewDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureViewDescriptor&
  operator=(const GPUTextureViewDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureViewDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureViewDescriptor : public GPUTextureViewDescriptor
{
  inline FastGPUTextureViewDescriptor()
    : GPUTextureViewDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexBufferLayout : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mArrayStride;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUVertexAttribute> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR GPUVertexStepMode mStepMode;

  GPUVertexBufferLayout();

  explicit inline GPUVertexBufferLayout(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUVertexBufferLayout(GPUVertexBufferLayout&& aOther) = default;

  explicit inline GPUVertexBufferLayout(const GPUVertexBufferLayout& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUVertexBufferLayout&
  operator=(const GPUVertexBufferLayout& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexBufferLayoutAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexBufferLayout : public GPUVertexBufferLayout
{
  inline FastGPUVertexBufferLayout()
    : GPUVertexBufferLayout(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict = TypeOrUninit::eGPUExtent3DDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUExtent3DDict > mGPUExtent3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

  RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict(const RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&) = delete;
  RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict& operator=(const RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&) = delete;
public:
  explicit inline RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
    : mType(eUninitialized)
  {
  }

  inline ~RangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  [[nodiscard]] inline binding_detail::FastGPUExtent3DDict&
  RawSetAsGPUExtent3DDict()
  {
    if (mType == eGPUExtent3DDict) {
      return mValue.mGPUExtent3DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUExtent3DDict;
    return mValue.mGPUExtent3DDict.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastGPUExtent3DDict&
  SetAsGPUExtent3DDict()
  {
    if (mType == eGPUExtent3DDict) {
      return mValue.mGPUExtent3DDict.Value();
    }
    Uninit();
    mType = eGPUExtent3DDict;
    return mValue.mGPUExtent3DDict.SetValue();
  }

  inline bool
  IsGPUExtent3DDict() const
  {
    return mType == eGPUExtent3DDict;
  }

  inline binding_detail::FastGPUExtent3DDict&
  GetAsGPUExtent3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  inline const GPUExtent3DDict&
  GetAsGPUExtent3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRangeEnforcedUnsignedLongSequence: {
        DestroyRangeEnforcedUnsignedLongSequence();
        break;
      }
      case eGPUExtent3DDict: {
        DestroyGPUExtent3DDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    mValue.mRangeEnforcedUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUExtent3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUExtent3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUExtent3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    mValue.mGPUExtent3DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUExtent3DDict = TypeOrUninit::eGPUExtent3DDict
  };

private:
  union Value
  {
    UnionMember<Sequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<GPUExtent3DDict > mGPUExtent3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
    : mType(eUninitialized)
  {
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict(OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&& aOther);

  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict(const OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict()
  {
    Uninit();
  }

  [[nodiscard]] Sequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence();

  [[nodiscard]] Sequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence();

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  [[nodiscard]] GPUExtent3DDict&
  RawSetAsGPUExtent3DDict();

  [[nodiscard]] GPUExtent3DDict&
  SetAsGPUExtent3DDict();

  inline bool
  IsGPUExtent3DDict() const
  {
    return mType == eGPUExtent3DDict;
  }

  inline GPUExtent3DDict&
  GetAsGPUExtent3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  inline GPUExtent3DDict const &
  GetAsGPUExtent3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&
  operator=(OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict&
  operator=(const OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict& aOther);

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRangeEnforcedUnsignedLongSequence();

  bool
  TrySetToGPUExtent3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUExtent3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUExtent3DDict();
};


class RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict = TypeOrUninit::eGPUOrigin2DDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUOrigin2DDict > mGPUOrigin2DDict;

  };

  TypeOrUninit mType;
  Value mValue;

  RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&) = delete;
  RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict& operator=(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&) = delete;
public:
  explicit inline RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
    : mType(eUninitialized)
  {
  }

  inline ~RangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  [[nodiscard]] inline binding_detail::FastGPUOrigin2DDict&
  RawSetAsGPUOrigin2DDict()
  {
    if (mType == eGPUOrigin2DDict) {
      return mValue.mGPUOrigin2DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOrigin2DDict;
    return mValue.mGPUOrigin2DDict.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastGPUOrigin2DDict&
  SetAsGPUOrigin2DDict()
  {
    if (mType == eGPUOrigin2DDict) {
      return mValue.mGPUOrigin2DDict.Value();
    }
    Uninit();
    mType = eGPUOrigin2DDict;
    return mValue.mGPUOrigin2DDict.SetValue();
  }

  inline bool
  IsGPUOrigin2DDict() const
  {
    return mType == eGPUOrigin2DDict;
  }

  inline binding_detail::FastGPUOrigin2DDict&
  GetAsGPUOrigin2DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  inline const GPUOrigin2DDict&
  GetAsGPUOrigin2DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRangeEnforcedUnsignedLongSequence: {
        DestroyRangeEnforcedUnsignedLongSequence();
        break;
      }
      case eGPUOrigin2DDict: {
        DestroyGPUOrigin2DDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    mValue.mRangeEnforcedUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUOrigin2DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin2DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUOrigin2DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    mValue.mGPUOrigin2DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin2DDict = TypeOrUninit::eGPUOrigin2DDict
  };

private:
  union Value
  {
    UnionMember<Sequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<GPUOrigin2DDict > mGPUOrigin2DDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
    : mType(eUninitialized)
  {
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&& aOther);

  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict()
  {
    Uninit();
  }

  [[nodiscard]] Sequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence();

  [[nodiscard]] Sequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence();

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  [[nodiscard]] GPUOrigin2DDict&
  RawSetAsGPUOrigin2DDict();

  [[nodiscard]] GPUOrigin2DDict&
  SetAsGPUOrigin2DDict();

  inline bool
  IsGPUOrigin2DDict() const
  {
    return mType == eGPUOrigin2DDict;
  }

  inline GPUOrigin2DDict&
  GetAsGPUOrigin2DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  inline GPUOrigin2DDict const &
  GetAsGPUOrigin2DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&
  operator=(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict&
  operator=(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict& aOther);

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRangeEnforcedUnsignedLongSequence();

  bool
  TrySetToGPUOrigin2DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin2DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUOrigin2DDict();
};


class RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict = TypeOrUninit::eGPUOrigin3DDict
  };

private:
  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUOrigin3DDict > mGPUOrigin3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

  RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&) = delete;
  RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict& operator=(const RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&) = delete;
public:
  explicit inline RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
    : mType(eUninitialized)
  {
  }

  inline ~RangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence()
  {
    if (mType == eRangeEnforcedUnsignedLongSequence) {
      return mValue.mRangeEnforcedUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eRangeEnforcedUnsignedLongSequence;
    return mValue.mRangeEnforcedUnsignedLongSequence.SetValue();
  }

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  [[nodiscard]] inline binding_detail::FastGPUOrigin3DDict&
  RawSetAsGPUOrigin3DDict()
  {
    if (mType == eGPUOrigin3DDict) {
      return mValue.mGPUOrigin3DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOrigin3DDict;
    return mValue.mGPUOrigin3DDict.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastGPUOrigin3DDict&
  SetAsGPUOrigin3DDict()
  {
    if (mType == eGPUOrigin3DDict) {
      return mValue.mGPUOrigin3DDict.Value();
    }
    Uninit();
    mType = eGPUOrigin3DDict;
    return mValue.mGPUOrigin3DDict.SetValue();
  }

  inline bool
  IsGPUOrigin3DDict() const
  {
    return mType == eGPUOrigin3DDict;
  }

  inline binding_detail::FastGPUOrigin3DDict&
  GetAsGPUOrigin3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  inline const GPUOrigin3DDict&
  GetAsGPUOrigin3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRangeEnforcedUnsignedLongSequence: {
        DestroyRangeEnforcedUnsignedLongSequence();
        break;
      }
      case eGPUOrigin3DDict: {
        DestroyGPUOrigin3DDict();
        break;
      }
    }
  }

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    mValue.mRangeEnforcedUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToGPUOrigin3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyGPUOrigin3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    mValue.mGPUOrigin3DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict
  };
public:
  enum class Type
  {
    eRangeEnforcedUnsignedLongSequence = TypeOrUninit::eRangeEnforcedUnsignedLongSequence,
    eGPUOrigin3DDict = TypeOrUninit::eGPUOrigin3DDict
  };

private:
  union Value
  {
    UnionMember<Sequence<uint32_t> > mRangeEnforcedUnsignedLongSequence;
    UnionMember<GPUOrigin3DDict > mGPUOrigin3DDict;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
    : mType(eUninitialized)
  {
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&& aOther);

  explicit inline OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict()
  {
    Uninit();
  }

  [[nodiscard]] Sequence<uint32_t>&
  RawSetAsRangeEnforcedUnsignedLongSequence();

  [[nodiscard]] Sequence<uint32_t>&
  SetAsRangeEnforcedUnsignedLongSequence();

  inline bool
  IsRangeEnforcedUnsignedLongSequence() const
  {
    return mType == eRangeEnforcedUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsRangeEnforcedUnsignedLongSequence()
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsRangeEnforcedUnsignedLongSequence() const
  {
    MOZ_RELEASE_ASSERT(IsRangeEnforcedUnsignedLongSequence(), "Wrong type!");
    return mValue.mRangeEnforcedUnsignedLongSequence.Value();
  }

  [[nodiscard]] GPUOrigin3DDict&
  RawSetAsGPUOrigin3DDict();

  [[nodiscard]] GPUOrigin3DDict&
  SetAsGPUOrigin3DDict();

  inline bool
  IsGPUOrigin3DDict() const
  {
    return mType == eGPUOrigin3DDict;
  }

  inline GPUOrigin3DDict&
  GetAsGPUOrigin3DDict()
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  inline GPUOrigin3DDict const &
  GetAsGPUOrigin3DDict() const
  {
    MOZ_RELEASE_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&
  operator=(OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict&
  operator=(const OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict& aOther);

private:
  bool
  TrySetToRangeEnforcedUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRangeEnforcedUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRangeEnforcedUnsignedLongSequence();

  bool
  TrySetToGPUOrigin3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyGPUOrigin3DDict();
};


struct GPUBindGroupEntry : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBinding;
  MOZ_INIT_OUTSIDE_CTOR OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding mResource;

  GPUBindGroupEntry();

  explicit inline GPUBindGroupEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupEntry(GPUBindGroupEntry&& aOther) = default;

  explicit inline GPUBindGroupEntry(const GPUBindGroupEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mResource, "mResource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mResource);
  }

  GPUBindGroupEntry&
  operator=(const GPUBindGroupEntry& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupEntry : public GPUBindGroupEntry
{
  inline FastGPUBindGroupEntry()
    : GPUBindGroupEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBindGroupLayoutDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUBindGroupLayoutEntry> mEntries;

  GPUBindGroupLayoutDescriptor();

  explicit inline GPUBindGroupLayoutDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupLayoutDescriptor(GPUBindGroupLayoutDescriptor&& aOther) = default;

  explicit inline GPUBindGroupLayoutDescriptor(const GPUBindGroupLayoutDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBindGroupLayoutDescriptor&
  operator=(const GPUBindGroupLayoutDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupLayoutDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupLayoutDescriptor : public GPUBindGroupLayoutDescriptor
{
  inline FastGPUBindGroupLayoutDescriptor()
    : GPUBindGroupLayoutDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUColorTargetState : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUBlendState> mBlend;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWriteMask;

  GPUColorTargetState();

  explicit inline GPUColorTargetState(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUColorTargetState(GPUColorTargetState&& aOther) = default;

  explicit inline GPUColorTargetState(const GPUColorTargetState& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUColorTargetState&
  operator=(const GPUColorTargetState& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUColorTargetStateAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUColorTargetState : public GPUColorTargetState
{
  inline FastGPUColorTargetState()
    : GPUColorTargetState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUComputePipelineDescriptor : public GPUPipelineDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUProgrammableStage mCompute;

  GPUComputePipelineDescriptor();

  explicit inline GPUComputePipelineDescriptor(const FastDictionaryInitializer& )
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mCompute(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUComputePipelineDescriptor(GPUComputePipelineDescriptor&& aOther) = default;

private:
  GPUComputePipelineDescriptor(const GPUComputePipelineDescriptor&) = delete;
  GPUComputePipelineDescriptor& operator=(const GPUComputePipelineDescriptor&) = delete;

  static bool
  InitIds(JSContext* cx, GPUComputePipelineDescriptorAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUPipelineDescriptorBase::TraverseForCC(aCallback, aFlags);
    ImplCycleCollectionTraverse(aCallback, mCompute, "mCompute", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUPipelineDescriptorBase::UnlinkForCC();
    ImplCycleCollectionUnlink(mCompute);
  }
};

namespace binding_detail {
struct FastGPUComputePipelineDescriptor : public GPUComputePipelineDescriptor
{
  inline FastGPUComputePipelineDescriptor()
    : GPUComputePipelineDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCopyExternalImageSourceInfo : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mFlipY;
  MOZ_INIT_OUTSIDE_CTOR OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin2DDict mOrigin;
  MOZ_INIT_OUTSIDE_CTOR OwningImageBitmapOrHTMLImageElementOrHTMLCanvasElementOrOffscreenCanvas mSource;

  GPUCopyExternalImageSourceInfo();

  explicit inline GPUCopyExternalImageSourceInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCopyExternalImageSourceInfo(GPUCopyExternalImageSourceInfo&& aOther) = default;

  explicit inline GPUCopyExternalImageSourceInfo(const GPUCopyExternalImageSourceInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSource, "mSource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSource);
  }

  GPUCopyExternalImageSourceInfo&
  operator=(const GPUCopyExternalImageSourceInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUCopyExternalImageSourceInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUCopyExternalImageSourceInfo : public GPUCopyExternalImageSourceInfo
{
  inline FastGPUCopyExternalImageSourceInfo()
    : GPUCopyExternalImageSourceInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUDeviceDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUQueueDescriptor mDefaultQueue;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUFeatureName> mRequiredFeatures;
  MOZ_INIT_OUTSIDE_CTOR Optional<Record<nsString, uint64_t>> mRequiredLimits;

  GPUDeviceDescriptor();

  explicit inline GPUDeviceDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer()),
      mDefaultQueue(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUDeviceDescriptor(GPUDeviceDescriptor&& aOther) = default;

private:
  GPUDeviceDescriptor(const GPUDeviceDescriptor&) = delete;
  GPUDeviceDescriptor& operator=(const GPUDeviceDescriptor&) = delete;

  static bool
  InitIds(JSContext* cx, GPUDeviceDescriptorAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastGPUDeviceDescriptor : public GPUDeviceDescriptor
{
  inline FastGPUDeviceDescriptor()
    : GPUDeviceDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderBundleEncoderDescriptor : public GPURenderPassLayout
{
  MOZ_INIT_OUTSIDE_CTOR bool mDepthReadOnly;
  MOZ_INIT_OUTSIDE_CTOR bool mStencilReadOnly;

  GPURenderBundleEncoderDescriptor();

  explicit inline GPURenderBundleEncoderDescriptor(const FastDictionaryInitializer& )
    : GPURenderPassLayout(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderBundleEncoderDescriptor(GPURenderBundleEncoderDescriptor&& aOther) = default;

  explicit inline GPURenderBundleEncoderDescriptor(const GPURenderBundleEncoderDescriptor& aOther)
    : GPURenderPassLayout(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderBundleEncoderDescriptor&
  operator=(const GPURenderBundleEncoderDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderBundleEncoderDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderBundleEncoderDescriptor : public GPURenderBundleEncoderDescriptor
{
  inline FastGPURenderBundleEncoderDescriptor()
    : GPURenderBundleEncoderDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassColorAttachment : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningDoubleSequenceOrGPUColorDict> mClearValue;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDepthSlice;
  MOZ_INIT_OUTSIDE_CTOR GPULoadOp mLoadOp;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::webgpu::TextureView>> mResolveTarget;
  MOZ_INIT_OUTSIDE_CTOR GPUStoreOp mStoreOp;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::TextureView> mView;

  GPURenderPassColorAttachment();

  explicit inline GPURenderPassColorAttachment(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassColorAttachment(GPURenderPassColorAttachment&& aOther) = default;

  explicit inline GPURenderPassColorAttachment(const GPURenderPassColorAttachment& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mResolveTarget, "mResolveTarget", aFlags);
    ImplCycleCollectionTraverse(aCallback, mView, "mView", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mResolveTarget);
    ImplCycleCollectionUnlink(mView);
  }

  GPURenderPassColorAttachment&
  operator=(const GPURenderPassColorAttachment& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassColorAttachmentAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassColorAttachment : public GPURenderPassColorAttachment
{
  inline FastGPURenderPassColorAttachment()
    : GPURenderPassColorAttachment(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUShaderModuleDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR nsCString mCode;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUShaderModuleCompilationHint> mCompilationHints;

  GPUShaderModuleDescriptor();

  explicit inline GPUShaderModuleDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUShaderModuleDescriptor(GPUShaderModuleDescriptor&& aOther) = default;

  explicit inline GPUShaderModuleDescriptor(const GPUShaderModuleDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mCompilationHints, "mCompilationHints", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mCompilationHints);
  }

  GPUShaderModuleDescriptor&
  operator=(const GPUShaderModuleDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUShaderModuleDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUShaderModuleDescriptor : public GPUShaderModuleDescriptor
{
  inline FastGPUShaderModuleDescriptor()
    : GPUShaderModuleDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTexelCopyTextureInfo : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUTextureAspect mAspect;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMipLevel;
  MOZ_INIT_OUTSIDE_CTOR OwningRangeEnforcedUnsignedLongSequenceOrGPUOrigin3DDict mOrigin;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Texture> mTexture;

  GPUTexelCopyTextureInfo();

  explicit inline GPUTexelCopyTextureInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTexelCopyTextureInfo(GPUTexelCopyTextureInfo&& aOther) = default;

  explicit inline GPUTexelCopyTextureInfo(const GPUTexelCopyTextureInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mTexture, "mTexture", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mTexture);
  }

  GPUTexelCopyTextureInfo&
  operator=(const GPUTexelCopyTextureInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTexelCopyTextureInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTexelCopyTextureInfo : public GPUTexelCopyTextureInfo
{
  inline FastGPUTexelCopyTextureInfo()
    : GPUTexelCopyTextureInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUTextureDimension mDimension;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMipLevelCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleCount;
  MOZ_INIT_OUTSIDE_CTOR OwningRangeEnforcedUnsignedLongSequenceOrGPUExtent3DDict mSize;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUTextureFormat> mViewFormats;

  GPUTextureDescriptor();

  explicit inline GPUTextureDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUTextureDescriptor(GPUTextureDescriptor&& aOther) = default;

  explicit inline GPUTextureDescriptor(const GPUTextureDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureDescriptor&
  operator=(const GPUTextureDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureDescriptor : public GPUTextureDescriptor
{
  inline FastGPUTextureDescriptor()
    : GPUTextureDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexState : public GPUProgrammableStage
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<Nullable<GPUVertexBufferLayout>> mBuffers;

  GPUVertexState();

  explicit inline GPUVertexState(const FastDictionaryInitializer& )
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUVertexState(GPUVertexState&& aOther) = default;

private:
  GPUVertexState(const GPUVertexState&) = delete;
  GPUVertexState& operator=(const GPUVertexState&) = delete;

  static bool
  InitIds(JSContext* cx, GPUVertexStateAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUProgrammableStage::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUProgrammableStage::UnlinkForCC();
  }
};

namespace binding_detail {
struct FastGPUVertexState : public GPUVertexState
{
  inline FastGPUVertexState()
    : GPUVertexState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBindGroupDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUBindGroupEntry> mEntries;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::BindGroupLayout> mLayout;

  GPUBindGroupDescriptor();

  explicit inline GPUBindGroupDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUBindGroupDescriptor(GPUBindGroupDescriptor&& aOther) = default;

  explicit inline GPUBindGroupDescriptor(const GPUBindGroupDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mEntries, "mEntries", aFlags);
    ImplCycleCollectionTraverse(aCallback, mLayout, "mLayout", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mEntries);
    ImplCycleCollectionUnlink(mLayout);
  }

  GPUBindGroupDescriptor&
  operator=(const GPUBindGroupDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupDescriptor : public GPUBindGroupDescriptor
{
  inline FastGPUBindGroupDescriptor()
    : GPUBindGroupDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCopyExternalImageDestInfo : public GPUTexelCopyTextureInfo
{
  MOZ_INIT_OUTSIDE_CTOR bool mPremultipliedAlpha;

  GPUCopyExternalImageDestInfo();

  explicit inline GPUCopyExternalImageDestInfo(const FastDictionaryInitializer& )
    : GPUTexelCopyTextureInfo(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUCopyExternalImageDestInfo(GPUCopyExternalImageDestInfo&& aOther) = default;

  explicit inline GPUCopyExternalImageDestInfo(const GPUCopyExternalImageDestInfo& aOther)
    : GPUTexelCopyTextureInfo(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUTexelCopyTextureInfo::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUTexelCopyTextureInfo::UnlinkForCC();
  }

  GPUCopyExternalImageDestInfo&
  operator=(const GPUCopyExternalImageDestInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUCopyExternalImageDestInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUCopyExternalImageDestInfo : public GPUCopyExternalImageDestInfo
{
  inline FastGPUCopyExternalImageDestInfo()
    : GPUCopyExternalImageDestInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUFragmentState : public GPUProgrammableStage
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUColorTargetState> mTargets;

  GPUFragmentState();

  explicit inline GPUFragmentState(const FastDictionaryInitializer& )
    : GPUProgrammableStage(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPUFragmentState(GPUFragmentState&& aOther) = default;

private:
  GPUFragmentState(const GPUFragmentState&) = delete;
  GPUFragmentState& operator=(const GPUFragmentState&) = delete;

  static bool
  InitIds(JSContext* cx, GPUFragmentStateAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUProgrammableStage::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUProgrammableStage::UnlinkForCC();
  }
};

namespace binding_detail {
struct FastGPUFragmentState : public GPUFragmentState
{
  inline FastGPUFragmentState()
    : GPUFragmentState(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPURenderPassColorAttachment> mColorAttachments;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPURenderPassDepthStencilAttachment> mDepthStencilAttachment;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::webgpu::QuerySet>> mOcclusionQuerySet;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPURenderPassTimestampWrites> mTimestampWrites;

  GPURenderPassDescriptor();

  explicit inline GPURenderPassDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPassDescriptor(GPURenderPassDescriptor&& aOther) = default;

  explicit inline GPURenderPassDescriptor(const GPURenderPassDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mColorAttachments, "mColorAttachments", aFlags);
    ImplCycleCollectionTraverse(aCallback, mDepthStencilAttachment, "mDepthStencilAttachment", aFlags);
    ImplCycleCollectionTraverse(aCallback, mOcclusionQuerySet, "mOcclusionQuerySet", aFlags);
    ImplCycleCollectionTraverse(aCallback, mTimestampWrites, "mTimestampWrites", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mColorAttachments);
    ImplCycleCollectionUnlink(mDepthStencilAttachment);
    ImplCycleCollectionUnlink(mOcclusionQuerySet);
    ImplCycleCollectionUnlink(mTimestampWrites);
  }

  GPURenderPassDescriptor&
  operator=(const GPURenderPassDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassDescriptor : public GPURenderPassDescriptor
{
  inline FastGPURenderPassDescriptor()
    : GPURenderPassDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPipelineDescriptor : public GPUPipelineDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUDepthStencilState> mDepthStencil;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUFragmentState> mFragment;
  MOZ_INIT_OUTSIDE_CTOR GPUMultisampleState mMultisample;
  MOZ_INIT_OUTSIDE_CTOR GPUPrimitiveState mPrimitive;
  MOZ_INIT_OUTSIDE_CTOR GPUVertexState mVertex;

  GPURenderPipelineDescriptor();

  explicit inline GPURenderPipelineDescriptor(const FastDictionaryInitializer& )
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mMultisample(FastDictionaryInitializer()),
      mPrimitive(FastDictionaryInitializer()),
      mVertex(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GPURenderPipelineDescriptor(GPURenderPipelineDescriptor&& aOther) = default;

private:
  GPURenderPipelineDescriptor(const GPURenderPipelineDescriptor&) = delete;
  GPURenderPipelineDescriptor& operator=(const GPURenderPipelineDescriptor&) = delete;

  static bool
  InitIds(JSContext* cx, GPURenderPipelineDescriptorAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUPipelineDescriptorBase::TraverseForCC(aCallback, aFlags);
    ImplCycleCollectionTraverse(aCallback, mFragment, "mFragment", aFlags);
    ImplCycleCollectionTraverse(aCallback, mVertex, "mVertex", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUPipelineDescriptorBase::UnlinkForCC();
    ImplCycleCollectionUnlink(mFragment);
    ImplCycleCollectionUnlink(mVertex);
  }
};

namespace binding_detail {
struct FastGPURenderPipelineDescriptor : public GPURenderPipelineDescriptor
{
  inline FastGPURenderPipelineDescriptor()
    : GPURenderPipelineDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace GPU_Binding {

  typedef mozilla::webgpu::Instance NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Instance* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPU,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPU_Binding



namespace GPUAdapter_Binding {

  typedef mozilla::webgpu::Adapter NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Adapter* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUAdapter,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUAdapter_Binding



namespace GPUAdapterInfo_Binding {

  typedef mozilla::webgpu::AdapterInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::AdapterInfo* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUAdapterInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUAdapterInfo_Binding



namespace GPUBindGroup_Binding {

  typedef mozilla::webgpu::BindGroup NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::BindGroup* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroup,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBindGroup_Binding



namespace GPUBindGroupLayout_Binding {

  typedef mozilla::webgpu::BindGroupLayout NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::BindGroupLayout* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroupLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBindGroupLayout_Binding



namespace GPUBuffer_Binding {

  typedef mozilla::webgpu::Buffer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Buffer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBuffer_Binding



namespace GPUBufferUsage_Binding {

  typedef mozilla::dom::GPUBufferUsage NativeType;

  static const uint32_t MAP_READ = 1;
  static const uint32_t MAP_WRITE = 2;
  static const uint32_t COPY_SRC = 4;
  static const uint32_t COPY_DST = 8;
  static const uint32_t INDEX = 16;
  static const uint32_t VERTEX = 32;
  static const uint32_t UNIFORM = 64;
  static const uint32_t STORAGE = 128;
  static const uint32_t INDIRECT = 256;
  static const uint32_t QUERY_RESOLVE = 512;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBufferUsage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUBufferUsage_Binding



namespace GPUCanvasContext_Binding {

  typedef mozilla::webgpu::CanvasContext NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CanvasContext* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCanvasContext,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCanvasContext_Binding



namespace GPUColorWrite_Binding {

  typedef mozilla::dom::GPUColorWrite NativeType;

  static const uint32_t RED = 1;
  static const uint32_t GREEN = 2;
  static const uint32_t BLUE = 4;
  static const uint32_t ALPHA = 8;
  static const uint32_t ALL = 15;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUColorWrite,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUColorWrite_Binding



namespace GPUCommandBuffer_Binding {

  typedef mozilla::webgpu::CommandBuffer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CommandBuffer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandBuffer,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCommandBuffer_Binding



namespace GPUCommandEncoder_Binding {

  typedef mozilla::webgpu::CommandEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CommandEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCommandEncoder_Binding



namespace GPUCompilationInfo_Binding {

  typedef mozilla::webgpu::CompilationInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CompilationInfo* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedMessagesValue(mozilla::webgpu::CompilationInfo* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCompilationInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCompilationInfo_Binding



namespace GPUCompilationMessage_Binding {

  typedef mozilla::webgpu::CompilationMessage NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CompilationMessage* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCompilationMessage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUCompilationMessage_Binding



namespace GPUComputePassEncoder_Binding {

  typedef mozilla::webgpu::ComputePassEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ComputePassEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUComputePassEncoder_Binding



namespace GPUComputePipeline_Binding {

  typedef mozilla::webgpu::ComputePipeline NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ComputePipeline* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUComputePipeline_Binding



namespace GPUDevice_Binding {

  typedef mozilla::webgpu::Device NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Device* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDevice,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUDevice_Binding



namespace GPUDeviceLostInfo_Binding {

  typedef mozilla::webgpu::DeviceLostInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::DeviceLostInfo* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDeviceLostInfo,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUDeviceLostInfo_Binding



namespace GPUError_Binding {

  typedef mozilla::webgpu::Error NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUError_Binding



namespace GPUExternalTexture_Binding {

  typedef mozilla::webgpu::ExtTex NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ExtTex* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUExternalTexture,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUExternalTexture_Binding



namespace GPUInternalError_Binding {

  typedef mozilla::webgpu::InternalError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::InternalError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUInternalError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUInternalError_Binding



namespace GPUMapMode_Binding {

  typedef mozilla::dom::GPUMapMode NativeType;

  static const uint32_t READ = 1;
  static const uint32_t WRITE = 2;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUMapMode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUMapMode_Binding



namespace GPUOutOfMemoryError_Binding {

  typedef mozilla::webgpu::OutOfMemoryError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::OutOfMemoryError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUOutOfMemoryError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUOutOfMemoryError_Binding



namespace GPUPipelineError_Binding {

  typedef mozilla::webgpu::PipelineError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::PipelineError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUPipelineError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUPipelineError_Binding



namespace GPUPipelineLayout_Binding {

  typedef mozilla::webgpu::PipelineLayout NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::PipelineLayout* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUPipelineLayout,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUPipelineLayout_Binding



namespace GPUQuerySet_Binding {

  typedef mozilla::webgpu::QuerySet NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::QuerySet* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUQuerySet,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUQuerySet_Binding



namespace GPUQueue_Binding {

  typedef mozilla::webgpu::Queue NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Queue* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUQueue,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUQueue_Binding



namespace GPURenderBundle_Binding {

  typedef mozilla::webgpu::RenderBundle NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderBundle* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundle,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderBundle_Binding



namespace GPURenderBundleEncoder_Binding {

  typedef mozilla::webgpu::RenderBundleEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderBundleEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundleEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderBundleEncoder_Binding



namespace GPURenderPassEncoder_Binding {

  typedef mozilla::webgpu::RenderPassEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderPassEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPassEncoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderPassEncoder_Binding



namespace GPURenderPipeline_Binding {

  typedef mozilla::webgpu::RenderPipeline NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderPipeline* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPipeline,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPURenderPipeline_Binding



namespace GPUSampler_Binding {

  typedef mozilla::webgpu::Sampler NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Sampler* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSampler,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUSampler_Binding



namespace GPUShaderModule_Binding {

  typedef mozilla::webgpu::ShaderModule NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ShaderModule* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderModule,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUShaderModule_Binding



namespace GPUShaderStage_Binding {

  typedef mozilla::dom::GPUShaderStage NativeType;

  static const uint32_t VERTEX = 1;
  static const uint32_t FRAGMENT = 2;
  static const uint32_t COMPUTE = 4;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderStage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUShaderStage_Binding



namespace GPUSupportedFeatures_Binding {

  typedef mozilla::webgpu::SupportedFeatures NativeType;

  namespace SetlikeHelpers {
  void
  Clear(mozilla::webgpu::SupportedFeatures* self, ErrorResult& aRv);
  bool
  Delete(mozilla::webgpu::SupportedFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  bool
  Has(mozilla::webgpu::SupportedFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  void
  Add(mozilla::webgpu::SupportedFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  } // namespace SetlikeHelpers

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::SupportedFeatures* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSupportedFeatures,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUSupportedFeatures_Binding



namespace GPUSupportedLimits_Binding {

  typedef mozilla::webgpu::SupportedLimits NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::SupportedLimits* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSupportedLimits,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUSupportedLimits_Binding



namespace GPUTexture_Binding {

  typedef mozilla::webgpu::Texture NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Texture* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTexture,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUTexture_Binding



namespace GPUTextureUsage_Binding {

  typedef mozilla::dom::GPUTextureUsage NativeType;

  static const uint32_t COPY_SRC = 1;
  static const uint32_t COPY_DST = 2;
  static const uint32_t TEXTURE_BINDING = 4;
  static const uint32_t STORAGE_BINDING = 8;
  static const uint32_t RENDER_ATTACHMENT = 16;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureUsage,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUTextureUsage_Binding



namespace GPUTextureView_Binding {

  typedef mozilla::webgpu::TextureView NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::TextureView* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureView,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUTextureView_Binding



namespace GPUValidationError_Binding {

  typedef mozilla::webgpu::ValidationError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ValidationError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUValidationError,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace GPUValidationError_Binding



namespace WGSLLanguageFeatures_Binding {

  typedef mozilla::webgpu::WGSLLanguageFeatures NativeType;

  namespace SetlikeHelpers {
  void
  Clear(mozilla::webgpu::WGSLLanguageFeatures* self, ErrorResult& aRv);
  bool
  Delete(mozilla::webgpu::WGSLLanguageFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  bool
  Has(mozilla::webgpu::WGSLLanguageFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  void
  Add(mozilla::webgpu::WGSLLanguageFeatures* self, const nsAString& aKey, ErrorResult& aRv);
  } // namespace SetlikeHelpers

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::WGSLLanguageFeatures* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::WGSLLanguageFeatures,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace WGSLLanguageFeatures_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::GPUPowerPreference>
{
  static constexpr dom::GPUPowerPreference value = dom::GPUPowerPreference::High_performance;

  static_assert(static_cast<uint8_t>(dom::GPUPowerPreference::Low_power) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUPowerPreference>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUFeatureName>
{
  static constexpr dom::GPUFeatureName value = dom::GPUFeatureName::Core_features_and_limits;

  static_assert(static_cast<uint8_t>(dom::GPUFeatureName::Depth_clip_control) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUFeatureName>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUBufferMapState>
{
  static constexpr dom::GPUBufferMapState value = dom::GPUBufferMapState::Mapped;

  static_assert(static_cast<uint8_t>(dom::GPUBufferMapState::Unmapped) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUBufferMapState>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUTextureDimension>
{
  static constexpr dom::GPUTextureDimension value = dom::GPUTextureDimension::_3d;

  static_assert(static_cast<uint8_t>(dom::GPUTextureDimension::_1d) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUTextureDimension>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUTextureViewDimension>
{
  static constexpr dom::GPUTextureViewDimension value = dom::GPUTextureViewDimension::_3d;

  static_assert(static_cast<uint8_t>(dom::GPUTextureViewDimension::_1d) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUTextureViewDimension>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUTextureAspect>
{
  static constexpr dom::GPUTextureAspect value = dom::GPUTextureAspect::Depth_only;

  static_assert(static_cast<uint8_t>(dom::GPUTextureAspect::All) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUTextureAspect>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUTextureFormat>
{
  static constexpr dom::GPUTextureFormat value = dom::GPUTextureFormat::Astc_12x12_unorm_srgb;

  static_assert(static_cast<uint8_t>(dom::GPUTextureFormat::R8unorm) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUTextureFormat>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUAddressMode>
{
  static constexpr dom::GPUAddressMode value = dom::GPUAddressMode::Mirror_repeat;

  static_assert(static_cast<uint8_t>(dom::GPUAddressMode::Clamp_to_edge) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUAddressMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUFilterMode>
{
  static constexpr dom::GPUFilterMode value = dom::GPUFilterMode::Linear;

  static_assert(static_cast<uint8_t>(dom::GPUFilterMode::Nearest) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUFilterMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUMipmapFilterMode>
{
  static constexpr dom::GPUMipmapFilterMode value = dom::GPUMipmapFilterMode::Linear;

  static_assert(static_cast<uint8_t>(dom::GPUMipmapFilterMode::Nearest) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUMipmapFilterMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUCompareFunction>
{
  static constexpr dom::GPUCompareFunction value = dom::GPUCompareFunction::Always;

  static_assert(static_cast<uint8_t>(dom::GPUCompareFunction::Never) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUCompareFunction>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUBufferBindingType>
{
  static constexpr dom::GPUBufferBindingType value = dom::GPUBufferBindingType::Read_only_storage;

  static_assert(static_cast<uint8_t>(dom::GPUBufferBindingType::Uniform) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUBufferBindingType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUSamplerBindingType>
{
  static constexpr dom::GPUSamplerBindingType value = dom::GPUSamplerBindingType::Comparison;

  static_assert(static_cast<uint8_t>(dom::GPUSamplerBindingType::Filtering) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUSamplerBindingType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUTextureSampleType>
{
  static constexpr dom::GPUTextureSampleType value = dom::GPUTextureSampleType::Uint;

  static_assert(static_cast<uint8_t>(dom::GPUTextureSampleType::Float) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUTextureSampleType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUStorageTextureAccess>
{
  static constexpr dom::GPUStorageTextureAccess value = dom::GPUStorageTextureAccess::Read_write;

  static_assert(static_cast<uint8_t>(dom::GPUStorageTextureAccess::Write_only) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUStorageTextureAccess>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUCompilationMessageType>
{
  static constexpr dom::GPUCompilationMessageType value = dom::GPUCompilationMessageType::Info;

  static_assert(static_cast<uint8_t>(dom::GPUCompilationMessageType::Error) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUCompilationMessageType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUPipelineErrorReason>
{
  static constexpr dom::GPUPipelineErrorReason value = dom::GPUPipelineErrorReason::Internal;

  static_assert(static_cast<uint8_t>(dom::GPUPipelineErrorReason::Validation) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUPipelineErrorReason>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUAutoLayoutMode>
{
  static constexpr dom::GPUAutoLayoutMode value = dom::GPUAutoLayoutMode::Auto;

  static_assert(static_cast<uint8_t>(dom::GPUAutoLayoutMode::Auto) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUAutoLayoutMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUPrimitiveTopology>
{
  static constexpr dom::GPUPrimitiveTopology value = dom::GPUPrimitiveTopology::Triangle_strip;

  static_assert(static_cast<uint8_t>(dom::GPUPrimitiveTopology::Point_list) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUPrimitiveTopology>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUFrontFace>
{
  static constexpr dom::GPUFrontFace value = dom::GPUFrontFace::Cw;

  static_assert(static_cast<uint8_t>(dom::GPUFrontFace::Ccw) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUFrontFace>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUCullMode>
{
  static constexpr dom::GPUCullMode value = dom::GPUCullMode::Back;

  static_assert(static_cast<uint8_t>(dom::GPUCullMode::None) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUCullMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUBlendFactor>
{
  static constexpr dom::GPUBlendFactor value = dom::GPUBlendFactor::One_minus_constant;

  static_assert(static_cast<uint8_t>(dom::GPUBlendFactor::Zero) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUBlendFactor>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUBlendOperation>
{
  static constexpr dom::GPUBlendOperation value = dom::GPUBlendOperation::Max;

  static_assert(static_cast<uint8_t>(dom::GPUBlendOperation::Add) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUBlendOperation>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUStencilOperation>
{
  static constexpr dom::GPUStencilOperation value = dom::GPUStencilOperation::Decrement_wrap;

  static_assert(static_cast<uint8_t>(dom::GPUStencilOperation::Keep) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUStencilOperation>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUIndexFormat>
{
  static constexpr dom::GPUIndexFormat value = dom::GPUIndexFormat::Uint32;

  static_assert(static_cast<uint8_t>(dom::GPUIndexFormat::Uint16) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUIndexFormat>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUVertexFormat>
{
  static constexpr dom::GPUVertexFormat value = dom::GPUVertexFormat::Unorm8x4_bgra;

  static_assert(static_cast<uint8_t>(dom::GPUVertexFormat::Uint8) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUVertexFormat>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUVertexStepMode>
{
  static constexpr dom::GPUVertexStepMode value = dom::GPUVertexStepMode::Instance;

  static_assert(static_cast<uint8_t>(dom::GPUVertexStepMode::Vertex) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUVertexStepMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPULoadOp>
{
  static constexpr dom::GPULoadOp value = dom::GPULoadOp::Clear;

  static_assert(static_cast<uint8_t>(dom::GPULoadOp::Load) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPULoadOp>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUStoreOp>
{
  static constexpr dom::GPUStoreOp value = dom::GPUStoreOp::Discard;

  static_assert(static_cast<uint8_t>(dom::GPUStoreOp::Store) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUStoreOp>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUQueryType>
{
  static constexpr dom::GPUQueryType value = dom::GPUQueryType::Timestamp;

  static_assert(static_cast<uint8_t>(dom::GPUQueryType::Occlusion) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUQueryType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUCanvasAlphaMode>
{
  static constexpr dom::GPUCanvasAlphaMode value = dom::GPUCanvasAlphaMode::Premultiplied;

  static_assert(static_cast<uint8_t>(dom::GPUCanvasAlphaMode::Opaque) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUCanvasAlphaMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUDeviceLostReason>
{
  static constexpr dom::GPUDeviceLostReason value = dom::GPUDeviceLostReason::Destroyed;

  static_assert(static_cast<uint8_t>(dom::GPUDeviceLostReason::Destroyed) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUDeviceLostReason>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::GPUErrorFilter>
{
  static constexpr dom::GPUErrorFilter value = dom::GPUErrorFilter::Internal;

  static_assert(static_cast<uint8_t>(dom::GPUErrorFilter::Validation) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::GPUErrorFilter>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_WEBGPUBINDING_H_
