// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitMozappsExtensionsMetrics_h
#define mozilla_GleanToolkitMozappsExtensionsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace addons {


}

namespace addons_manager {
  /**
   * generated from addons_manager.compatibility_check_enabled
   * Whether application compatibility is enforced for add-ons.
   */
  constexpr impl::BooleanMetric compatibility_check_enabled(5731);

  /**
   * generated from addons_manager.install
   */
  struct InstallExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<uint32_t> downloadTime;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> installId;
    mozilla::Maybe<nsCString> installOrigins;
    mozilla::Maybe<uint32_t> numStrings;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> sourceMethod;
    mozilla::Maybe<nsCString> step;
    mozilla::Maybe<nsCString> updatedFrom;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (downloadTime) {
        extraKeys.AppendElement()->AssignASCII("download_time");
        extraValues.AppendElement()->AppendInt(downloadTime.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (installId) {
        extraKeys.AppendElement()->AssignASCII("install_id");
        extraValues.EmplaceBack(installId.value());
      }
      if (installOrigins) {
        extraKeys.AppendElement()->AssignASCII("install_origins");
        extraValues.EmplaceBack(installOrigins.value());
      }
      if (numStrings) {
        extraKeys.AppendElement()->AssignASCII("num_strings");
        extraValues.AppendElement()->AppendInt(numStrings.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (sourceMethod) {
        extraKeys.AppendElement()->AssignASCII("source_method");
        extraValues.EmplaceBack(sourceMethod.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.EmplaceBack(step.value());
      }
      if (updatedFrom) {
        extraKeys.AppendElement()->AssignASCII("updated_from");
        extraValues.EmplaceBack(updatedFrom.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are recorded during the install and update flow for
   * extensions and themes.
   */
  constexpr impl::EventMetric<InstallExtra> install(5732);

  /**
   * generated from addons_manager.install_stats
   */
  struct InstallStatsExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<nsCString> taarBased;
    mozilla::Maybe<nsCString> utmCampaign;
    mozilla::Maybe<nsCString> utmContent;
    mozilla::Maybe<nsCString> utmMedium;
    mozilla::Maybe<nsCString> utmSource;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (taarBased) {
        extraKeys.AppendElement()->AssignASCII("taar_based");
        extraValues.EmplaceBack(taarBased.value());
      }
      if (utmCampaign) {
        extraKeys.AppendElement()->AssignASCII("utm_campaign");
        extraValues.EmplaceBack(utmCampaign.value());
      }
      if (utmContent) {
        extraKeys.AppendElement()->AssignASCII("utm_content");
        extraValues.EmplaceBack(utmContent.value());
      }
      if (utmMedium) {
        extraKeys.AppendElement()->AssignASCII("utm_medium");
        extraValues.EmplaceBack(utmMedium.value());
      }
      if (utmSource) {
        extraKeys.AppendElement()->AssignASCII("utm_source");
        extraValues.EmplaceBack(utmSource.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are recorded at the end of the install flow, but only
   * when the source that originally triggered the add-on installation
   * is "amo", "rtamo" or "disco".
   */
  constexpr impl::EventMetric<InstallStatsExtra> install_stats(5733);

  /**
   * generated from addons_manager.manage
   */
  struct ManageExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<nsCString> blocklistState;
    mozilla::Maybe<nsCString> method;
    mozilla::Maybe<uint32_t> numStrings;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> sourceMethod;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (blocklistState) {
        extraKeys.AppendElement()->AssignASCII("blocklist_state");
        extraValues.EmplaceBack(blocklistState.value());
      }
      if (method) {
        extraKeys.AppendElement()->AssignASCII("method");
        extraValues.EmplaceBack(method.value());
      }
      if (numStrings) {
        extraKeys.AppendElement()->AssignASCII("num_strings");
        extraValues.AppendElement()->AppendInt(numStrings.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (sourceMethod) {
        extraKeys.AppendElement()->AssignASCII("source_method");
        extraValues.EmplaceBack(sourceMethod.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This events are recorded when an installed add-ons is being
   * disable/enabled/uninstalled.
   */
  constexpr impl::EventMetric<ManageExtra> manage(5734);

  /**
   * generated from addons_manager.report_suspicious_site
   */
  struct ReportSuspiciousSiteExtra {
    mozilla::Maybe<nsCString> suspiciousSite;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (suspiciousSite) {
        extraKeys.AppendElement()->AssignASCII("suspicious_site");
        extraValues.EmplaceBack(suspiciousSite.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when a user clicks "Report Suspicious Site" on the dropdown
   * menu of the third-party xpinstall doorhanger.
   */
  constexpr impl::EventMetric<ReportSuspiciousSiteExtra> report_suspicious_site(5735);

  /**
   * generated from addons_manager.update
   */
  struct UpdateExtra {
    mozilla::Maybe<nsCString> addonId;
    mozilla::Maybe<nsCString> addonType;
    mozilla::Maybe<uint32_t> downloadTime;
    mozilla::Maybe<nsCString> error;
    mozilla::Maybe<nsCString> installId;
    mozilla::Maybe<nsCString> installOrigins;
    mozilla::Maybe<uint32_t> numStrings;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> sourceMethod;
    mozilla::Maybe<nsCString> step;
    mozilla::Maybe<nsCString> updatedFrom;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonId) {
        extraKeys.AppendElement()->AssignASCII("addon_id");
        extraValues.EmplaceBack(addonId.value());
      }
      if (addonType) {
        extraKeys.AppendElement()->AssignASCII("addon_type");
        extraValues.EmplaceBack(addonType.value());
      }
      if (downloadTime) {
        extraKeys.AppendElement()->AssignASCII("download_time");
        extraValues.AppendElement()->AppendInt(downloadTime.value());
      }
      if (error) {
        extraKeys.AppendElement()->AssignASCII("error");
        extraValues.EmplaceBack(error.value());
      }
      if (installId) {
        extraKeys.AppendElement()->AssignASCII("install_id");
        extraValues.EmplaceBack(installId.value());
      }
      if (installOrigins) {
        extraKeys.AppendElement()->AssignASCII("install_origins");
        extraValues.EmplaceBack(installOrigins.value());
      }
      if (numStrings) {
        extraKeys.AppendElement()->AssignASCII("num_strings");
        extraValues.AppendElement()->AppendInt(numStrings.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (sourceMethod) {
        extraKeys.AppendElement()->AssignASCII("source_method");
        extraValues.EmplaceBack(sourceMethod.value());
      }
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.EmplaceBack(step.value());
      }
      if (updatedFrom) {
        extraKeys.AppendElement()->AssignASCII("updated_from");
        extraValues.EmplaceBack(updatedFrom.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * These events are recorded during the install and update flow for
   * extensions and themes.
   */
  constexpr impl::EventMetric<UpdateExtra> update(5736);

  /**
   * generated from addons_manager.xpistates_write_errors
   */
  struct XpistatesWriteErrorsExtra {
    mozilla::Maybe<nsCString> errorType;
    mozilla::Maybe<nsCString> profileState;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorType) {
        extraKeys.AppendElement()->AssignASCII("error_type");
        extraValues.EmplaceBack(errorType.value());
      }
      if (profileState) {
        extraKeys.AppendElement()->AssignASCII("profile_state");
        extraValues.EmplaceBack(profileState.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Sent when saving addonStartup.json.lz4 data back to disk fails.
   */
  constexpr impl::EventMetric<XpistatesWriteErrorsExtra> xpistates_write_errors(5737);
}

namespace blocklist {
  /**
   * generated from blocklist.addon_block_change
   */
  struct AddonBlockChangeExtra {
    mozilla::Maybe<nsCString> addonVersion;
    mozilla::Maybe<nsCString> blocklistState;
    mozilla::Maybe<nsCString> hoursSince;
    mozilla::Maybe<nsCString> mlbfGeneration;
    mozilla::Maybe<nsCString> mlbfLastTime;
    mozilla::Maybe<nsCString> mlbfSoftblocksGeneration;
    mozilla::Maybe<nsCString> mlbfSoftblocksSource;
    mozilla::Maybe<nsCString> mlbfSource;
    mozilla::Maybe<nsCString> object;
    mozilla::Maybe<nsCString> signedDate;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (addonVersion) {
        extraKeys.AppendElement()->AssignASCII("addon_version");
        extraValues.EmplaceBack(addonVersion.value());
      }
      if (blocklistState) {
        extraKeys.AppendElement()->AssignASCII("blocklist_state");
        extraValues.EmplaceBack(blocklistState.value());
      }
      if (hoursSince) {
        extraKeys.AppendElement()->AssignASCII("hours_since");
        extraValues.EmplaceBack(hoursSince.value());
      }
      if (mlbfGeneration) {
        extraKeys.AppendElement()->AssignASCII("mlbf_generation");
        extraValues.EmplaceBack(mlbfGeneration.value());
      }
      if (mlbfLastTime) {
        extraKeys.AppendElement()->AssignASCII("mlbf_last_time");
        extraValues.EmplaceBack(mlbfLastTime.value());
      }
      if (mlbfSoftblocksGeneration) {
        extraKeys.AppendElement()->AssignASCII("mlbf_softblocks_generation");
        extraValues.EmplaceBack(mlbfSoftblocksGeneration.value());
      }
      if (mlbfSoftblocksSource) {
        extraKeys.AppendElement()->AssignASCII("mlbf_softblocks_source");
        extraValues.EmplaceBack(mlbfSoftblocksSource.value());
      }
      if (mlbfSource) {
        extraKeys.AppendElement()->AssignASCII("mlbf_source");
        extraValues.EmplaceBack(mlbfSource.value());
      }
      if (object) {
        extraKeys.AppendElement()->AssignASCII("object");
        extraValues.EmplaceBack(object.value());
      }
      if (signedDate) {
        extraKeys.AppendElement()->AssignASCII("signed_date");
        extraValues.EmplaceBack(signedDate.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * An add-on is blocked, or an installed add-on is unblocked. When an add-on install/update is blocked, its installation is aborted and the add-on is no longer listed in the activeAddons field of TelemetryEnvironment.
   */
  constexpr impl::EventMetric<AddonBlockChangeExtra> addon_block_change(5794);

  /**
   * generated from blocklist.enabled
   * Whether the extension blocklist is enabled.
   * Corresponds to the `extensions.blocklist.enabled` pref.
   */
  constexpr impl::BooleanMetric enabled(5795);

  /**
   * generated from blocklist.last_modified_rs_addons_mblf
   * Keep track of the last time the "addons-bloomfilters" remotesetting blocklist has been successfully updated.
   */
  constexpr impl::DatetimeMetric last_modified_rs_addons_mblf(5796);

  /**
   * generated from blocklist.mlbf_generation_time
   * Keep track of the generation time of the addon blocklist's bloom filter. This marks the point in time until which signed add-ons are recognized by the selected bloom filter from the addons-bloomfilters collection.
   */
  constexpr impl::DatetimeMetric mlbf_generation_time(5797);

  /**
   * generated from blocklist.mlbf_softblocks_generation_time
   * Keep track of the generation time of the addon blocklist's bloom filter. This marks the point in time until which signed add-ons are recognized by the selected bloom filter from the addons-bloomfilters collection.
   */
  constexpr impl::DatetimeMetric mlbf_softblocks_generation_time(5798);

  /**
   * generated from blocklist.mlbf_softblocks_source
   * The source of the RemoteSettings attachment that holds the bloom filter. Possible values are "dump_match", "cache_match", "remote_match","dump_fallback", "cache_fallback", "unknown". "dump_match", "cache_match" and "remote_match" are expected known-good values, and means that the loaded bloomfilter matches the blocklist record in the RemoteSettings collection. The prefix denotes the immediate source of the loaded data: "dump" means packaged with the application, "remote" means a freshly downloaded bloomfilter, "cache" means a previously downloaded bloomfilter. "dump_fallback" and "cache_fallback" means that the last known bloomfilter was used, despite it not matching the latest record in the RemoteSettings collection. In this case the outdated bloomfilter is used as a fallback (e.g. because the latest version cannot be downloaded). "unknown"  means that the bloomfilter cannot be loaded at all. This can happen if the blocklist is disabled via preferences or enterprise policies.
   */
  constexpr impl::StringMetric mlbf_softblocks_source(5799);

  /**
   * generated from blocklist.mlbf_source
   * The source of the RemoteSettings attachment that holds the bloom filter. Possible values are "dump_match", "cache_match", "remote_match","dump_fallback", "cache_fallback", "unknown". "dump_match", "cache_match" and "remote_match" are expected known-good values, and means that the loaded bloomfilter matches the blocklist record in the RemoteSettings collection. The prefix denotes the immediate source of the loaded data: "dump" means packaged with the application, "remote" means a freshly downloaded bloomfilter, "cache" means a previously downloaded bloomfilter. "dump_fallback" and "cache_fallback" means that the last known bloomfilter was used, despite it not matching the latest record in the RemoteSettings collection. In this case the outdated bloomfilter is used as a fallback (e.g. because the latest version cannot be downloaded). "unknown"  means that the bloomfilter cannot be loaded at all. This can happen if the blocklist is disabled via preferences or enterprise policies.
   */
  constexpr impl::StringMetric mlbf_source(5800);

  /**
   * generated from blocklist.mlbf_stash_time_newest
   * Keep track of the timestamp of the most recent stash of the addons blocklist.
   */
  constexpr impl::DatetimeMetric mlbf_stash_time_newest(5801);

  /**
   * generated from blocklist.mlbf_stash_time_oldest
   * Keep track of the timestamp of the oldest stash of the addons blocklist.
   */
  constexpr impl::DatetimeMetric mlbf_stash_time_oldest(5802);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitMozappsExtensionsMetrics_h
