// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanBackupMetrics_h
#define mozilla_GleanBackupMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_backup {
  /**
   * generated from browser.backup.archive_disabled_reason
   * Only set if `browser.backup.enabled` is `false`. Possible reasons are "nimbus", "pref" (non-Nimbus), "policy", "sanitizeOnShutdown", "selectable profiles", "os version".
   */
  constexpr impl::StringMetric archive_disabled_reason(249);

  /**
   * generated from browser.backup.archive_enabled
   * True if the user can create backups, i.e. it has not been disabled by a pref or otherwise deemed incompatible.
   */
  constexpr impl::BooleanMetric archive_enabled(250);

  /**
   * generated from browser.backup.backup_start
   */
  struct BackupStartExtra {
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a backup is initiated.
   */
  constexpr impl::EventMetric<BackupStartExtra> backup_start(251);

  /**
   * generated from browser.backup.backup_throttled
   */
  /**
   * Dispatched when backups are throttled due to too many errors.
   */
  constexpr impl::EventMetric<NoExtraKeys> backup_throttled(252);

  /**
   * generated from browser.backup.browser_extension_data_size
   * The total size of the current profiles storage.local legacy JSON backend in the browser-extension-data directory, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric browser_extension_data_size(253);

  /**
   * generated from browser.backup.change_location
   */
  /**
   * Dispatched when the backup destination location is changed.
   */
  constexpr impl::EventMetric<NoExtraKeys> change_location(254);

  /**
   * generated from browser.backup.compressed_archive_size
   * The total compressed size of a single-file profile data backup archive. To reduce fingerprintability, we round to the nearest 1 mebibyte.
   */
  constexpr impl::MemoryDistributionMetric compressed_archive_size(255);

  /**
   * generated from browser.backup.cookies_size
   * The total file size of the cookies.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric cookies_size(256);

  /**
   * generated from browser.backup.created
   */
  struct CreatedExtra {
    mozilla::Maybe<bool> encrypted;
    mozilla::Maybe<nsCString> location;
    mozilla::Maybe<uint32_t> size;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (encrypted) {
        extraKeys.AppendElement()->AssignASCII("encrypted");
        extraValues.AppendElement()->AssignASCII(encrypted.value() ? "true" : "false");
      }
      if (location) {
        extraKeys.AppendElement()->AssignASCII("location");
        extraValues.EmplaceBack(location.value());
      }
      if (size) {
        extraKeys.AppendElement()->AssignASCII("size");
        extraValues.AppendElement()->AppendInt(size.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a backup is successfully created.
   */
  constexpr impl::EventMetric<CreatedExtra> created(257);

  /**
   * generated from browser.backup.credentials_data_size
   * The total size of logins, payment method, and form autofill related files in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric credentials_data_size(258);

  /**
   * generated from browser.backup.enabled
   * True if the BackupService has initialized and reached idle. You may want to use archive_enabled/restore_enabled to determine whether those features are available, or use scheduler_enabled for whether automatic backups are enabled.
   */
  constexpr impl::BooleanMetric enabled(259);

  /**
   * generated from browser.backup.error
   */
  struct ErrorExtra {
    mozilla::Maybe<nsCString> backupStep;
    mozilla::Maybe<nsCString> errorCode;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (backupStep) {
        extraKeys.AppendElement()->AssignASCII("backup_step");
        extraValues.EmplaceBack(backupStep.value());
      }
      if (errorCode) {
        extraKeys.AppendElement()->AssignASCII("error_code");
        extraValues.EmplaceBack(errorCode.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a backup fails to be created. We encode the error code as well as the stage the backup failed in in the extra data.
   */
  constexpr impl::EventMetric<ErrorExtra> error(260);

  /**
   * generated from browser.backup.extension_store_permissions_data_size
   * The file size of the current profiles extension-store-permissions/data.safe.bin file, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extension_store_permissions_data_size(261);

  /**
   * generated from browser.backup.extensions_json_size
   * The total file size of the current profiles extensions metadata files, rounded to the nearest 10 kilobytes. Files included are:
   *   - extensions.json
   *   - extension-settings.json
   *   - extension-preferences.json
   *   - addonStartup.json.lz4
   */
  constexpr impl::QuantityMetric extensions_json_size(262);

  /**
   * generated from browser.backup.extensions_storage_size
   * The total size of all extensions storage directories, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extensions_storage_size(263);

  /**
   * generated from browser.backup.extensions_xpi_directory_size
   * The total size of the current profiles extensions directory, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric extensions_xpi_directory_size(264);

  /**
   * generated from browser.backup.favicons_size
   * The total file size of the favicons.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric favicons_size(265);

  /**
   * generated from browser.backup.favicons_time
   * Total time, in milliseconds, required to back up a profile's favicons database.
   */
  constexpr impl::TimingDistributionMetric favicons_time(266);

  /**
   * generated from browser.backup.form_history_size
   * The file size of the formhistory.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric form_history_size(267);

  /**
   * generated from browser.backup.location_on_device
   * 1 = the default location, 2 = a non-default location
   */
  constexpr impl::QuantityMetric location_on_device(268);

  /**
   * generated from browser.backup.misc_data_size
   * The total size of files for telemetry, site storage, media device origin mapping, chrome privileged IndexedDB databases, and Mozilla Accounts in the current profile directory, rounded to the nearest tenth kilobyte.
   */
  constexpr impl::QuantityMetric misc_data_size(269);

  /**
   * generated from browser.backup.password_added
   */
  /**
   * Dispatched when the backup encryption is enabled.
   */
  constexpr impl::EventMetric<NoExtraKeys> password_added(270);

  /**
   * generated from browser.backup.password_changed
   */
  /**
   * Dispatched when the backup encryption password is changed.
   */
  constexpr impl::EventMetric<NoExtraKeys> password_changed(271);

  /**
   * generated from browser.backup.password_removed
   */
  /**
   * Dispatched when the backup encryption is removed.
   */
  constexpr impl::EventMetric<NoExtraKeys> password_removed(272);

  /**
   * generated from browser.backup.places_size
   * The total file size of the places.sqlite db located in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric places_size(273);

  /**
   * generated from browser.backup.places_time
   * Total time, in milliseconds, required to back up a profile's places database.
   */
  constexpr impl::TimingDistributionMetric places_time(274);

  /**
   * generated from browser.backup.preferences_size
   * The total size of files relating to user preferences and permissions in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric preferences_size(275);

  /**
   * generated from browser.backup.prof_d_disk_space
   * The total disk space available on the storage device that the profile directory is stored on. To reduce fingerprintability, we round to the nearest 10 megabytes and return the result in kilobytes.
   */
  constexpr impl::QuantityMetric prof_d_disk_space(276);

  /**
   * generated from browser.backup.pswd_encrypted
   * True if the BackupService is configured to encrypt backups.
   */
  constexpr impl::BooleanMetric pswd_encrypted(277);

  /**
   * generated from browser.backup.restore_complete
   */
  struct RestoreCompleteExtra {
    mozilla::Maybe<nsCString> restoreId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (restoreId) {
        extraKeys.AppendElement()->AssignASCII("restore_id");
        extraValues.EmplaceBack(restoreId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a restore completes, just before the browser restarts into the restored profile.
   */
  constexpr impl::EventMetric<RestoreCompleteExtra> restore_complete(278);

  /**
   * generated from browser.backup.restore_disabled_reason
   * Only set if `browser.backup.enabled` is `false`. Possible reasons are "nimbus", "pref" (non-Nimbus), "policy", "sanitizeOnShutdown", "selectable profiles".
   */
  constexpr impl::StringMetric restore_disabled_reason(279);

  /**
   * generated from browser.backup.restore_enabled
   * True if the user can restore backups, i.e. it has not been disabled by a pref or otherwise deemed incompatible.
   */
  constexpr impl::BooleanMetric restore_enabled(280);

  /**
   * generated from browser.backup.restore_failed
   */
  struct RestoreFailedExtra {
    mozilla::Maybe<nsCString> errorType;
    mozilla::Maybe<nsCString> restoreId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorType) {
        extraKeys.AppendElement()->AssignASCII("error_type");
        extraValues.EmplaceBack(errorType.value());
      }
      if (restoreId) {
        extraKeys.AppendElement()->AssignASCII("restore_id");
        extraValues.EmplaceBack(restoreId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a restore fails (prior to Firefox restart).
   */
  constexpr impl::EventMetric<RestoreFailedExtra> restore_failed(281);

  /**
   * generated from browser.backup.restore_file_chosen
   */
  struct RestoreFileChosenExtra {
    mozilla::Maybe<nsCString> appName;
    mozilla::Maybe<uint32_t> backupTimestamp;
    mozilla::Maybe<nsCString> buildId;
    mozilla::Maybe<bool> encryption;
    mozilla::Maybe<nsCString> location;
    mozilla::Maybe<nsCString> osName;
    mozilla::Maybe<nsCString> osVersion;
    mozilla::Maybe<nsCString> restoreId;
    mozilla::Maybe<bool> telemetryEnabled;
    mozilla::Maybe<bool> valid;
    mozilla::Maybe<nsCString> version;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (appName) {
        extraKeys.AppendElement()->AssignASCII("app_name");
        extraValues.EmplaceBack(appName.value());
      }
      if (backupTimestamp) {
        extraKeys.AppendElement()->AssignASCII("backup_timestamp");
        extraValues.AppendElement()->AppendInt(backupTimestamp.value());
      }
      if (buildId) {
        extraKeys.AppendElement()->AssignASCII("build_id");
        extraValues.EmplaceBack(buildId.value());
      }
      if (encryption) {
        extraKeys.AppendElement()->AssignASCII("encryption");
        extraValues.AppendElement()->AssignASCII(encryption.value() ? "true" : "false");
      }
      if (location) {
        extraKeys.AppendElement()->AssignASCII("location");
        extraValues.EmplaceBack(location.value());
      }
      if (osName) {
        extraKeys.AppendElement()->AssignASCII("os_name");
        extraValues.EmplaceBack(osName.value());
      }
      if (osVersion) {
        extraKeys.AppendElement()->AssignASCII("os_version");
        extraValues.EmplaceBack(osVersion.value());
      }
      if (restoreId) {
        extraKeys.AppendElement()->AssignASCII("restore_id");
        extraValues.EmplaceBack(restoreId.value());
      }
      if (telemetryEnabled) {
        extraKeys.AppendElement()->AssignASCII("telemetry_enabled");
        extraValues.AppendElement()->AssignASCII(telemetryEnabled.value() ? "true" : "false");
      }
      if (valid) {
        extraKeys.AppendElement()->AssignASCII("valid");
        extraValues.AppendElement()->AssignASCII(valid.value() ? "true" : "false");
      }
      if (version) {
        extraKeys.AppendElement()->AssignASCII("version");
        extraValues.EmplaceBack(version.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a file is chosen to be restored.
   */
  constexpr impl::EventMetric<RestoreFileChosenExtra> restore_file_chosen(282);

  /**
   * generated from browser.backup.restore_started
   */
  struct RestoreStartedExtra {
    mozilla::Maybe<nsCString> restoreId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (restoreId) {
        extraKeys.AppendElement()->AssignASCII("restore_id");
        extraValues.EmplaceBack(restoreId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a file is chosen to be restored.
   */
  constexpr impl::EventMetric<RestoreStartedExtra> restore_started(283);

  /**
   * generated from browser.backup.restored_profile_data
   */

  struct RestoredProfileDataObject {
    Maybe<bool> is_restored;
    Maybe<int64_t> backup_timestamp;
    Maybe<nsCString> backup_app_name;
    Maybe<nsCString> backup_app_version;
    Maybe<nsCString> backup_build_id;
    Maybe<nsCString> backup_os_name;
    Maybe<nsCString> backup_os_version;
    Maybe<nsCString> backup_legacy_client_id;
  };
  /**
   * Describes the backup that was restored to make the current profile. If This is not a restored profile, `is_restored` will be set to `false` and no other values will be set.
   */
  constexpr impl::ObjectMetric<RestoredProfileDataObject, struct RestoredProfileDataObjectTag> restored_profile_data(284);

  /**
   * generated from browser.backup.restored_profile_launched
   */
  struct RestoredProfileLaunchedExtra {
    mozilla::Maybe<nsCString> restoreId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (restoreId) {
        extraKeys.AppendElement()->AssignASCII("restore_id");
        extraValues.EmplaceBack(restoreId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when a restore completes, after the browser restarts into the restored profile (from that profile). Note that this will not be sent if the new profile has telemetry disabled.
   */
  constexpr impl::EventMetric<RestoredProfileLaunchedExtra> restored_profile_launched(285);

  /**
   * generated from browser.backup.scheduler_enabled
   * True if the BackupService is configured to automatically create backups in the background.
   */
  constexpr impl::BooleanMetric scheduler_enabled(286);

  /**
   * generated from browser.backup.security_data_size
   * The total size of files needed for NSS initialization parameters and security certificate settings in the current profile directory, in kilobytes.
   */
  constexpr impl::QuantityMetric security_data_size(287);

  /**
   * generated from browser.backup.session_store_backups_directory_size
   * The total size of the session store backups directory, in kilobytes.
   */
  constexpr impl::QuantityMetric session_store_backups_directory_size(288);

  /**
   * generated from browser.backup.session_store_size
   * The size of uncompressed session store json, in kilobytes.
   */
  constexpr impl::QuantityMetric session_store_size(289);

  /**
   * generated from browser.backup.storage_sync_size
   * The file size of the current profiles storage-sync-v2.sqlite db, rounded to the nearest 10 kilobytes.
   */
  constexpr impl::QuantityMetric storage_sync_size(290);

  /**
   * generated from browser.backup.toggle_off
   */
  /**
   * Dispatched when scheduled backups are disabled.
   */
  constexpr impl::EventMetric<NoExtraKeys> toggle_off(291);

  /**
   * generated from browser.backup.toggle_on
   */
  struct ToggleOnExtra {
    mozilla::Maybe<bool> encrypted;
    mozilla::Maybe<nsCString> location;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (encrypted) {
        extraKeys.AppendElement()->AssignASCII("encrypted");
        extraValues.AppendElement()->AssignASCII(encrypted.value() ? "true" : "false");
      }
      if (location) {
        extraKeys.AppendElement()->AssignASCII("location");
        extraValues.EmplaceBack(location.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Dispatched when scheduled backups are enabled.
   */
  constexpr impl::EventMetric<ToggleOnExtra> toggle_on(292);

  /**
   * generated from browser.backup.total_backup_size
   * The total uncompressed size of all profile data included in a completed backup. To reduce fingerprintability, we round to the nearest 1 mebibyte.
   */
  constexpr impl::MemoryDistributionMetric total_backup_size(293);

  /**
   * generated from browser.backup.total_backup_time
   * Total time elapsed, in milliseconds, between the start and end of the profile backup creation process
   */
  constexpr impl::TimingDistributionMetric total_backup_time(294);
}

template <>
inline void impl::ObjectMetric<browser_backup::RestoredProfileDataObject, browser_backup::RestoredProfileDataObjectTag>::Set(const browser_backup::RestoredProfileDataObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.is_restored.isSome()) {
      writer.BoolProperty("is_restored", *(aObj.is_restored));
    }
    if (aObj.backup_timestamp.isSome()) {
      writer.IntProperty("backup_timestamp", *(aObj.backup_timestamp));
    }
    if (aObj.backup_app_name.isSome()) {
      writer.StringProperty("backup_app_name", *(aObj.backup_app_name));
    }
    if (aObj.backup_app_version.isSome()) {
      writer.StringProperty("backup_app_version", *(aObj.backup_app_version));
    }
    if (aObj.backup_build_id.isSome()) {
      writer.StringProperty("backup_build_id", *(aObj.backup_build_id));
    }
    if (aObj.backup_os_name.isSome()) {
      writer.StringProperty("backup_os_name", *(aObj.backup_os_name));
    }
    if (aObj.backup_os_version.isSome()) {
      writer.StringProperty("backup_os_version", *(aObj.backup_os_version));
    }
    if (aObj.backup_legacy_client_id.isSome()) {
      writer.StringProperty("backup_legacy_client_id", *(aObj.backup_legacy_client_id));
    }
  }
  writer.EndObject();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanBackupMetrics_h
