/* THIS FILE IS AUTOGENERATED FROM ChromeUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ChromeUtilsBinding_h
#define mozilla_dom_ChromeUtilsBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "nsIURI.h"

class nsIURI;

namespace mozilla {
namespace dom {

struct Base64URLDecodeOptionsAtoms;
struct Base64URLEncodeOptionsAtoms;
struct CategoryDispatchDictionary;
struct CategoryDispatchDictionaryAtoms;
struct ChildProcInfoDictionary;
struct ChildProcInfoDictionaryAtoms;
class ChromeUtils;
struct CompileScriptOptionsDictionaryAtoms;
struct FormAutofillConfidencesAtoms;
struct HeapSnapshotBoundariesAtoms;
struct IOActivityDataDictionaryAtoms;
struct ImportESModuleOptionsDictionaryAtoms;
struct InteractionDataAtoms;
struct MediaMemoryInfoDictionary;
struct MediaMemoryInfoDictionaryAtoms;
struct MemoryInfoDictionary;
struct MemoryInfoDictionaryAtoms;
class MozQueryInterface;
struct NativePropertyHooks;
struct OriginAttributesDictionaryAtoms;
struct OriginAttributesPatternDictionaryAtoms;
struct ParentProcInfoDictionaryAtoms;
struct PartitionKeyPatternDictionary;
struct PartitionKeyPatternDictionaryAtoms;
struct PerformanceInfoDictionaryAtoms;
struct ProfilerMarkerOptionsAtoms;
class ProtoAndIfaceCache;
struct ThreadInfoDictionary;
struct ThreadInfoDictionaryAtoms;
struct UtilityActorsDictionary;
struct UtilityActorsDictionaryAtoms;
struct WindowInfoDictionary;
struct WindowInfoDictionaryAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class WebIDLProcType : uint8_t {
  Web,
  WebIsolated,
  File,
  Extension,
  Privilegedabout,
  Privilegedmozilla,
  WithCoopCoep,
  WebServiceWorker,
  Browser,
  IpdlUnitTest,
  GmpPlugin,
  Gpu,
  Vr,
  Rdd,
  Socket,
  RemoteSandboxBroker,
  Utility,
  Preallocated,
  Unknown,
  EndGuard_
};

namespace WebIDLProcTypeValues {
extern const EnumEntry strings[20];

static constexpr size_t Count = 19;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(WebIDLProcType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(WebIDLProcType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace WebIDLProcTypeValues

bool
ToJSValue(JSContext* aCx, WebIDLProcType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class WebIDLUtilityActorName : uint8_t {
  Unknown,
  AudioDecoder_Generic,
  AudioDecoder_AppleMedia,
  AudioDecoder_WMF,
  MfMediaEngineCDM,
  JSOracle,
  WindowsUtils,
  EndGuard_
};

namespace WebIDLUtilityActorNameValues {
extern const EnumEntry strings[8];

static constexpr size_t Count = 7;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(WebIDLUtilityActorName::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(WebIDLUtilityActorName stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace WebIDLUtilityActorNameValues

bool
ToJSValue(JSContext* aCx, WebIDLUtilityActorName aArgument, JS::MutableHandle<JS::Value> aValue);


enum class Base64URLDecodePadding : uint8_t {
  Require,
  Ignore,
  Reject,
  EndGuard_
};

namespace Base64URLDecodePaddingValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(Base64URLDecodePadding::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(Base64URLDecodePadding stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace Base64URLDecodePaddingValues

bool
ToJSValue(JSContext* aCx, Base64URLDecodePadding aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PopupBlockerState : uint8_t {
  OpenAllowed,
  OpenControlled,
  OpenBlocked,
  OpenAbused,
  OpenOverridden,
  EndGuard_
};

namespace PopupBlockerStateValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(PopupBlockerState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(PopupBlockerState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace PopupBlockerStateValues

bool
ToJSValue(JSContext* aCx, PopupBlockerState aArgument, JS::MutableHandle<JS::Value> aValue);


struct Base64URLDecodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Base64URLDecodePadding mPadding;

  Base64URLDecodeOptions();

  explicit inline Base64URLDecodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  Base64URLDecodeOptions(Base64URLDecodeOptions&& aOther) = default;

  explicit inline Base64URLDecodeOptions(const Base64URLDecodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  Base64URLDecodeOptions&
  operator=(const Base64URLDecodeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, Base64URLDecodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBase64URLDecodeOptions : public Base64URLDecodeOptions
{
  inline FastBase64URLDecodeOptions()
    : Base64URLDecodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct Base64URLEncodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mPad;

  Base64URLEncodeOptions();

  explicit inline Base64URLEncodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  Base64URLEncodeOptions(Base64URLEncodeOptions&& aOther) = default;

  explicit inline Base64URLEncodeOptions(const Base64URLEncodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  Base64URLEncodeOptions&
  operator=(const Base64URLEncodeOptions& aOther);

  bool
  operator==(const Base64URLEncodeOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, Base64URLEncodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBase64URLEncodeOptions : public Base64URLEncodeOptions
{
  inline FastBase64URLEncodeOptions()
    : Base64URLEncodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CategoryDispatchDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint16_t mCategory;
  MOZ_INIT_OUTSIDE_CTOR uint16_t mCount;

  CategoryDispatchDictionary();

  explicit inline CategoryDispatchDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CategoryDispatchDictionary(CategoryDispatchDictionary&& aOther) = default;

  explicit inline CategoryDispatchDictionary(const CategoryDispatchDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  CategoryDispatchDictionary&
  operator=(const CategoryDispatchDictionary& aOther);

  bool
  operator==(const CategoryDispatchDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, CategoryDispatchDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastCategoryDispatchDictionary : public CategoryDispatchDictionary
{
  inline FastCategoryDispatchDictionary()
    : CategoryDispatchDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CompileScriptOptionsDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mCharset;
  MOZ_INIT_OUTSIDE_CTOR bool mHasReturnValue;
  MOZ_INIT_OUTSIDE_CTOR bool mLazilyParse;

  CompileScriptOptionsDictionary();

  explicit inline CompileScriptOptionsDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CompileScriptOptionsDictionary(CompileScriptOptionsDictionary&& aOther) = default;

  explicit inline CompileScriptOptionsDictionary(const CompileScriptOptionsDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  CompileScriptOptionsDictionary&
  operator=(const CompileScriptOptionsDictionary& aOther);

  bool
  operator==(const CompileScriptOptionsDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, CompileScriptOptionsDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastCompileScriptOptionsDictionary : public CompileScriptOptionsDictionary
{
  inline FastCompileScriptOptionsDictionary()
    : CompileScriptOptionsDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FormAutofillConfidences : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mCcName;
  MOZ_INIT_OUTSIDE_CTOR double mCcNumber;

  FormAutofillConfidences();

  explicit inline FormAutofillConfidences(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FormAutofillConfidences(FormAutofillConfidences&& aOther) = default;

  explicit inline FormAutofillConfidences(const FormAutofillConfidences& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  FormAutofillConfidences&
  operator=(const FormAutofillConfidences& aOther);

  bool
  operator==(const FormAutofillConfidences& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, FormAutofillConfidencesAtoms* atomsCache);
};

namespace binding_detail {
struct FastFormAutofillConfidences : public FormAutofillConfidences
{
  inline FastFormAutofillConfidences()
    : FormAutofillConfidences(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HeapSnapshotBoundaries : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<JSObject*> mDebugger;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<JSObject*>> mGlobals;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mRuntime;

  HeapSnapshotBoundaries();

  explicit inline HeapSnapshotBoundaries(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  HeapSnapshotBoundaries(HeapSnapshotBoundaries&& aOther) = default;

private:
  HeapSnapshotBoundaries(const HeapSnapshotBoundaries&) = delete;
  HeapSnapshotBoundaries& operator=(const HeapSnapshotBoundaries&) = delete;

  static bool
  InitIds(JSContext* cx, HeapSnapshotBoundariesAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastHeapSnapshotBoundaries : public HeapSnapshotBoundaries
{
  inline FastHeapSnapshotBoundaries()
    : HeapSnapshotBoundaries(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct IOActivityDataDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsCString mLocation;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mRx;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mTx;

  IOActivityDataDictionary();

  explicit inline IOActivityDataDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  IOActivityDataDictionary(IOActivityDataDictionary&& aOther) = default;

  explicit inline IOActivityDataDictionary(const IOActivityDataDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  IOActivityDataDictionary&
  operator=(const IOActivityDataDictionary& aOther);

  bool
  operator==(const IOActivityDataDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, IOActivityDataDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastIOActivityDataDictionary : public IOActivityDataDictionary
{
  inline FastIOActivityDataDictionary()
    : IOActivityDataDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ImportESModuleOptionsDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mLoadInDevToolsLoader;

  ImportESModuleOptionsDictionary();

  explicit inline ImportESModuleOptionsDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ImportESModuleOptionsDictionary(ImportESModuleOptionsDictionary&& aOther) = default;

  explicit inline ImportESModuleOptionsDictionary(const ImportESModuleOptionsDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ImportESModuleOptionsDictionary&
  operator=(const ImportESModuleOptionsDictionary& aOther);

  bool
  operator==(const ImportESModuleOptionsDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ImportESModuleOptionsDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastImportESModuleOptionsDictionary : public ImportESModuleOptionsDictionary
{
  inline FastImportESModuleOptionsDictionary()
    : ImportESModuleOptionsDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct InteractionData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mInteractionCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mInteractionTimeInMilliseconds;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mScrollingDistanceInPixels;

  InteractionData();

  explicit inline InteractionData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  InteractionData(InteractionData&& aOther) = default;

  explicit inline InteractionData(const InteractionData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InteractionData&
  operator=(const InteractionData& aOther);

  bool
  operator==(const InteractionData& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, InteractionDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastInteractionData : public InteractionData
{
  inline FastInteractionData()
    : InteractionData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaMemoryInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mAudioSize;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mResourcesSize;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mVideoSize;

  MediaMemoryInfoDictionary();

  explicit inline MediaMemoryInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MediaMemoryInfoDictionary(MediaMemoryInfoDictionary&& aOther) = default;

  explicit inline MediaMemoryInfoDictionary(const MediaMemoryInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MediaMemoryInfoDictionary&
  operator=(const MediaMemoryInfoDictionary& aOther);

  bool
  operator==(const MediaMemoryInfoDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MediaMemoryInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaMemoryInfoDictionary : public MediaMemoryInfoDictionary
{
  inline FastMediaMemoryInfoDictionary()
    : MediaMemoryInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct OriginAttributesDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mFirstPartyDomain;
  MOZ_INIT_OUTSIDE_CTOR nsString mGeckoViewSessionContextId;
  MOZ_INIT_OUTSIDE_CTOR bool mInIsolatedMozBrowser;
  MOZ_INIT_OUTSIDE_CTOR nsString mPartitionKey;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPrivateBrowsingId;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUserContextId;

  OriginAttributesDictionary();

  explicit inline OriginAttributesDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  OriginAttributesDictionary(OriginAttributesDictionary&& aOther) = default;

  explicit inline OriginAttributesDictionary(const OriginAttributesDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  OriginAttributesDictionary&
  operator=(const OriginAttributesDictionary& aOther);

  bool
  operator==(const OriginAttributesDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, OriginAttributesDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastOriginAttributesDictionary : public OriginAttributesDictionary
{
  inline FastOriginAttributesDictionary()
    : OriginAttributesDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PartitionKeyPatternDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mBaseDomain;
  MOZ_INIT_OUTSIDE_CTOR Optional<int32_t> mPort;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mScheme;

  PartitionKeyPatternDictionary();

  explicit inline PartitionKeyPatternDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PartitionKeyPatternDictionary(PartitionKeyPatternDictionary&& aOther) = default;

  explicit inline PartitionKeyPatternDictionary(const PartitionKeyPatternDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PartitionKeyPatternDictionary&
  operator=(const PartitionKeyPatternDictionary& aOther);

  bool
  operator==(const PartitionKeyPatternDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, PartitionKeyPatternDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastPartitionKeyPatternDictionary : public PartitionKeyPatternDictionary
{
  inline FastPartitionKeyPatternDictionary()
    : PartitionKeyPatternDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ProfilerMarkerOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCaptureStack;
  MOZ_INIT_OUTSIDE_CTOR nsCString mCategory;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mInnerWindowId;
  MOZ_INIT_OUTSIDE_CTOR double mStartTime;

  ProfilerMarkerOptions();

  explicit inline ProfilerMarkerOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ProfilerMarkerOptions(ProfilerMarkerOptions&& aOther) = default;

  explicit inline ProfilerMarkerOptions(const ProfilerMarkerOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ProfilerMarkerOptions&
  operator=(const ProfilerMarkerOptions& aOther);

  bool
  operator==(const ProfilerMarkerOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ProfilerMarkerOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastProfilerMarkerOptions : public ProfilerMarkerOptions
{
  inline FastProfilerMarkerOptions()
    : ProfilerMarkerOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ThreadInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuCycleCount;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuTime;
  MOZ_INIT_OUTSIDE_CTOR nsString mName;
  MOZ_INIT_OUTSIDE_CTOR int64_t mTid;

  ThreadInfoDictionary();

  explicit inline ThreadInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ThreadInfoDictionary(ThreadInfoDictionary&& aOther) = default;

  explicit inline ThreadInfoDictionary(const ThreadInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  ThreadInfoDictionary&
  operator=(const ThreadInfoDictionary& aOther);

  bool
  operator==(const ThreadInfoDictionary& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ThreadInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastThreadInfoDictionary : public ThreadInfoDictionary
{
  inline FastThreadInfoDictionary()
    : ThreadInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct UtilityActorsDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR WebIDLUtilityActorName mActorName;

  UtilityActorsDictionary();

  explicit inline UtilityActorsDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  UtilityActorsDictionary(UtilityActorsDictionary&& aOther) = default;

  explicit inline UtilityActorsDictionary(const UtilityActorsDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  UtilityActorsDictionary&
  operator=(const UtilityActorsDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, UtilityActorsDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastUtilityActorsDictionary : public UtilityActorsDictionary
{
  inline FastUtilityActorsDictionary()
    : UtilityActorsDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct WindowInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mDocumentTitle;
  MOZ_INIT_OUTSIDE_CTOR RefPtr<nsIURI> mDocumentURI;
  MOZ_INIT_OUTSIDE_CTOR bool mIsInProcess;
  MOZ_INIT_OUTSIDE_CTOR bool mIsProcessRoot;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOuterWindowId;

  WindowInfoDictionary();

  explicit inline WindowInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WindowInfoDictionary(WindowInfoDictionary&& aOther) = default;

  explicit inline WindowInfoDictionary(const WindowInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mDocumentURI, "mDocumentURI", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mDocumentURI);
  }

  WindowInfoDictionary&
  operator=(const WindowInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, WindowInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastWindowInfoDictionary : public WindowInfoDictionary
{
  inline FastWindowInfoDictionary()
    : WindowInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ChildProcInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mChildID;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuCycleCount;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuTime;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mMemory;
  MOZ_INIT_OUTSIDE_CTOR nsCString mOrigin;
  MOZ_INIT_OUTSIDE_CTOR int64_t mPid;
  MOZ_INIT_OUTSIDE_CTOR Sequence<ThreadInfoDictionary> mThreads;
  MOZ_INIT_OUTSIDE_CTOR WebIDLProcType mType;
  MOZ_INIT_OUTSIDE_CTOR Sequence<UtilityActorsDictionary> mUtilityActors;
  MOZ_INIT_OUTSIDE_CTOR Sequence<WindowInfoDictionary> mWindows;

  ChildProcInfoDictionary();

  explicit inline ChildProcInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ChildProcInfoDictionary(ChildProcInfoDictionary&& aOther) = default;

  explicit inline ChildProcInfoDictionary(const ChildProcInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mWindows, "mWindows", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mWindows);
  }

  ChildProcInfoDictionary&
  operator=(const ChildProcInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ChildProcInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastChildProcInfoDictionary : public ChildProcInfoDictionary
{
  inline FastChildProcInfoDictionary()
    : ChildProcInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MemoryInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDomDom;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDomOther;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDomStyle;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mJsMemUsage;
  MOZ_INIT_OUTSIDE_CTOR MediaMemoryInfoDictionary mMedia;

  MemoryInfoDictionary();

  explicit inline MemoryInfoDictionary(const FastDictionaryInitializer& )
    : mMedia(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MemoryInfoDictionary(MemoryInfoDictionary&& aOther) = default;

  explicit inline MemoryInfoDictionary(const MemoryInfoDictionary& aOther)
    : mMedia(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MemoryInfoDictionary&
  operator=(const MemoryInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, MemoryInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastMemoryInfoDictionary : public MemoryInfoDictionary
{
  inline FastMemoryInfoDictionary()
    : MemoryInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct OriginAttributesPatternDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mFirstPartyDomain;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mGeckoViewSessionContextId;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mInIsolatedMozBrowser;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPartitionKey;
  MOZ_INIT_OUTSIDE_CTOR Optional<PartitionKeyPatternDictionary> mPartitionKeyPattern;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPrivateBrowsingId;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mUserContextId;

  OriginAttributesPatternDictionary();

  explicit inline OriginAttributesPatternDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  OriginAttributesPatternDictionary(OriginAttributesPatternDictionary&& aOther) = default;

  explicit inline OriginAttributesPatternDictionary(const OriginAttributesPatternDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  OriginAttributesPatternDictionary&
  operator=(const OriginAttributesPatternDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, OriginAttributesPatternDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastOriginAttributesPatternDictionary : public OriginAttributesPatternDictionary
{
  inline FastOriginAttributesPatternDictionary()
    : OriginAttributesPatternDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ProfilerMarkerOptionsOrDouble
{
  enum TypeOrUninit
  {
    eUninitialized,
    eProfilerMarkerOptions,
    eDouble
  };
public:
  enum class Type
  {
    eProfilerMarkerOptions = TypeOrUninit::eProfilerMarkerOptions,
    eDouble = TypeOrUninit::eDouble
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastProfilerMarkerOptions > mProfilerMarkerOptions;
    UnionMember<double > mDouble;

  };

  TypeOrUninit mType;
  Value mValue;

  ProfilerMarkerOptionsOrDouble(const ProfilerMarkerOptionsOrDouble&) = delete;
  ProfilerMarkerOptionsOrDouble& operator=(const ProfilerMarkerOptionsOrDouble&) = delete;
public:
  explicit inline ProfilerMarkerOptionsOrDouble()
    : mType(eUninitialized)
  {
  }

  inline ~ProfilerMarkerOptionsOrDouble()
  {
    Uninit();
  }

  inline binding_detail::FastProfilerMarkerOptions&
  RawSetAsProfilerMarkerOptions()
  {
    if (mType == eProfilerMarkerOptions) {
      return mValue.mProfilerMarkerOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eProfilerMarkerOptions;
    return mValue.mProfilerMarkerOptions.SetValue();
  }

  inline binding_detail::FastProfilerMarkerOptions&
  SetAsProfilerMarkerOptions()
  {
    if (mType == eProfilerMarkerOptions) {
      return mValue.mProfilerMarkerOptions.Value();
    }
    Uninit();
    mType = eProfilerMarkerOptions;
    return mValue.mProfilerMarkerOptions.SetValue();
  }

  inline bool
  IsProfilerMarkerOptions() const
  {
    return mType == eProfilerMarkerOptions;
  }

  inline binding_detail::FastProfilerMarkerOptions&
  GetAsProfilerMarkerOptions()
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  inline const ProfilerMarkerOptions&
  GetAsProfilerMarkerOptions() const
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eProfilerMarkerOptions: {
        DestroyProfilerMarkerOptions();
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
    }
  }

private:
  bool
  TrySetToProfilerMarkerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToProfilerMarkerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyProfilerMarkerOptions()
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    mValue.mProfilerMarkerOptions.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }
};


class OwningProfilerMarkerOptionsOrDouble : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eProfilerMarkerOptions,
    eDouble
  };
public:
  enum class Type
  {
    eProfilerMarkerOptions = TypeOrUninit::eProfilerMarkerOptions,
    eDouble = TypeOrUninit::eDouble
  };

private:
  union Value
  {
    UnionMember<ProfilerMarkerOptions > mProfilerMarkerOptions;
    UnionMember<double > mDouble;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningProfilerMarkerOptionsOrDouble()
    : mType(eUninitialized)
  {
  }

  OwningProfilerMarkerOptionsOrDouble(OwningProfilerMarkerOptionsOrDouble&& aOther);

  explicit inline OwningProfilerMarkerOptionsOrDouble(const OwningProfilerMarkerOptionsOrDouble& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningProfilerMarkerOptionsOrDouble()
  {
    Uninit();
  }

  ProfilerMarkerOptions&
  RawSetAsProfilerMarkerOptions();

  ProfilerMarkerOptions&
  SetAsProfilerMarkerOptions();

  inline bool
  IsProfilerMarkerOptions() const
  {
    return mType == eProfilerMarkerOptions;
  }

  inline ProfilerMarkerOptions&
  GetAsProfilerMarkerOptions()
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  inline ProfilerMarkerOptions const &
  GetAsProfilerMarkerOptions() const
  {
    MOZ_RELEASE_ASSERT(IsProfilerMarkerOptions(), "Wrong type!");
    return mValue.mProfilerMarkerOptions.Value();
  }

  double&
  RawSetAsDouble();

  double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningProfilerMarkerOptionsOrDouble&
  operator=(OwningProfilerMarkerOptionsOrDouble&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningProfilerMarkerOptionsOrDouble&
  operator=(const OwningProfilerMarkerOptionsOrDouble& aOther);

private:
  bool
  TrySetToProfilerMarkerOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToProfilerMarkerOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyProfilerMarkerOptions();

  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();
};


struct ParentProcInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<ChildProcInfoDictionary> mChildren;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuCycleCount;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCpuTime;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mMemory;
  MOZ_INIT_OUTSIDE_CTOR int64_t mPid;
  MOZ_INIT_OUTSIDE_CTOR Sequence<ThreadInfoDictionary> mThreads;
  MOZ_INIT_OUTSIDE_CTOR WebIDLProcType mType;

  ParentProcInfoDictionary();

  explicit inline ParentProcInfoDictionary(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ParentProcInfoDictionary(ParentProcInfoDictionary&& aOther) = default;

  explicit inline ParentProcInfoDictionary(const ParentProcInfoDictionary& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mChildren, "mChildren", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mChildren);
  }

  ParentProcInfoDictionary&
  operator=(const ParentProcInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, ParentProcInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastParentProcInfoDictionary : public ParentProcInfoDictionary
{
  inline FastParentProcInfoDictionary()
    : ParentProcInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct PerformanceInfoDictionary : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mCounterId;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mDuration;
  MOZ_INIT_OUTSIDE_CTOR nsCString mHost;
  MOZ_INIT_OUTSIDE_CTOR bool mIsTopLevel;
  MOZ_INIT_OUTSIDE_CTOR bool mIsWorker;
  MOZ_INIT_OUTSIDE_CTOR Sequence<CategoryDispatchDictionary> mItems;
  MOZ_INIT_OUTSIDE_CTOR MemoryInfoDictionary mMemoryInfo;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPid;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mWindowId;

  PerformanceInfoDictionary();

  explicit inline PerformanceInfoDictionary(const FastDictionaryInitializer& )
    : mMemoryInfo(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  PerformanceInfoDictionary(PerformanceInfoDictionary&& aOther) = default;

  explicit inline PerformanceInfoDictionary(const PerformanceInfoDictionary& aOther)
    : mMemoryInfo(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  PerformanceInfoDictionary&
  operator=(const PerformanceInfoDictionary& aOther);

private:
  static bool
  InitIds(JSContext* cx, PerformanceInfoDictionaryAtoms* atomsCache);
};

namespace binding_detail {
struct FastPerformanceInfoDictionary : public PerformanceInfoDictionary
{
  inline FastPerformanceInfoDictionary()
    : PerformanceInfoDictionary(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ChromeUtils_Binding {

  typedef mozilla::dom::ChromeUtils NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::ChromeUtils,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ChromeUtils,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ChromeUtils_Binding



namespace MozQueryInterface_Binding {

  typedef mozilla::dom::MozQueryInterface NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::MozQueryInterface* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MozQueryInterface,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MozQueryInterface,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MozQueryInterface,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MozQueryInterface_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_ChromeUtilsBinding_h
