/* THIS FILE IS AUTOGENERATED FROM Localization.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_LocalizationBinding_h
#define mozilla_dom_LocalizationBinding_h

#include "FluentBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

namespace dom {

struct AttributeNameValue;
struct AttributeNameValueAtoms;
struct L10nArgsHelperDictAtoms;
struct L10nIdArgsAtoms;
struct L10nMessageAtoms;
struct NativePropertyHooks;
class OwningUTF8StringOrDouble;
class ProtoAndIfaceCache;
class UTF8StringOrDouble;

} // namespace dom

namespace intl {

class Localization;

} // namespace intl

} // namespace mozilla

namespace mozilla::dom {

struct AttributeNameValue : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsCString mName;
  MOZ_INIT_OUTSIDE_CTOR nsCString mValue;

  AttributeNameValue();

  explicit inline AttributeNameValue(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  AttributeNameValue(AttributeNameValue&& aOther) = default;

  explicit inline AttributeNameValue(const AttributeNameValue& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  AttributeNameValue&
  operator=(const AttributeNameValue& aOther);

  bool
  operator==(const AttributeNameValue& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, AttributeNameValueAtoms* atomsCache);
};

namespace binding_detail {
struct FastAttributeNameValue : public AttributeNameValue
{
  inline FastAttributeNameValue()
    : AttributeNameValue(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct L10nArgsHelperDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Record<nsCString, Nullable<OwningUTF8StringOrDouble >> mArgs;

  L10nArgsHelperDict();

  explicit inline L10nArgsHelperDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  L10nArgsHelperDict(L10nArgsHelperDict&& aOther) = default;

private:
  L10nArgsHelperDict(const L10nArgsHelperDict&) = delete;
  L10nArgsHelperDict& operator=(const L10nArgsHelperDict&) = delete;

  static bool
  InitIds(JSContext* cx, L10nArgsHelperDictAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastL10nArgsHelperDict : public L10nArgsHelperDict
{
  inline FastL10nArgsHelperDict()
    : L10nArgsHelperDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct L10nIdArgs : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Nullable<Record<nsCString, Nullable<OwningUTF8StringOrDouble >>> mArgs;
  MOZ_INIT_OUTSIDE_CTOR nsCString mId;

  L10nIdArgs();

  explicit inline L10nIdArgs(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  L10nIdArgs(L10nIdArgs&& aOther) = default;

private:
  L10nIdArgs(const L10nIdArgs&) = delete;
  L10nIdArgs& operator=(const L10nIdArgs&) = delete;

  static bool
  InitIds(JSContext* cx, L10nIdArgsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastL10nIdArgs : public L10nIdArgs
{
  inline FastL10nIdArgs()
    : L10nIdArgs(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct L10nMessage : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Nullable<Sequence<AttributeNameValue>> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR nsCString mValue;

  L10nMessage();

  explicit inline L10nMessage(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  L10nMessage(L10nMessage&& aOther) = default;

  explicit inline L10nMessage(const L10nMessage& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  L10nMessage&
  operator=(const L10nMessage& aOther);

private:
  static bool
  InitIds(JSContext* cx, L10nMessageAtoms* atomsCache);
};

namespace binding_detail {
struct FastL10nMessage : public L10nMessage
{
  inline FastL10nMessage()
    : L10nMessage(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrL10nIdArgs
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eL10nIdArgs
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eL10nIdArgs = TypeOrUninit::eL10nIdArgs
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<binding_detail::FastL10nIdArgs > mL10nIdArgs;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrL10nIdArgs(const UTF8StringOrL10nIdArgs&) = delete;
  UTF8StringOrL10nIdArgs& operator=(const UTF8StringOrL10nIdArgs&) = delete;
public:
  explicit inline UTF8StringOrL10nIdArgs()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrL10nIdArgs()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline binding_detail::FastL10nIdArgs&
  RawSetAsL10nIdArgs()
  {
    if (mType == eL10nIdArgs) {
      return mValue.mL10nIdArgs.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eL10nIdArgs;
    return mValue.mL10nIdArgs.SetValue();
  }

  inline binding_detail::FastL10nIdArgs&
  SetAsL10nIdArgs()
  {
    if (mType == eL10nIdArgs) {
      return mValue.mL10nIdArgs.Value();
    }
    Uninit();
    mType = eL10nIdArgs;
    return mValue.mL10nIdArgs.SetValue();
  }

  inline bool
  IsL10nIdArgs() const
  {
    return mType == eL10nIdArgs;
  }

  inline binding_detail::FastL10nIdArgs&
  GetAsL10nIdArgs()
  {
    MOZ_RELEASE_ASSERT(IsL10nIdArgs(), "Wrong type!");
    return mValue.mL10nIdArgs.Value();
  }

  inline const L10nIdArgs&
  GetAsL10nIdArgs() const
  {
    MOZ_RELEASE_ASSERT(IsL10nIdArgs(), "Wrong type!");
    return mValue.mL10nIdArgs.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eL10nIdArgs: {
        DestroyL10nIdArgs();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToL10nIdArgs(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToL10nIdArgs(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyL10nIdArgs()
  {
    MOZ_RELEASE_ASSERT(IsL10nIdArgs(), "Wrong type!");
    mValue.mL10nIdArgs.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrL10nIdArgs : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eL10nIdArgs
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eL10nIdArgs = TypeOrUninit::eL10nIdArgs
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<L10nIdArgs > mL10nIdArgs;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningUTF8StringOrL10nIdArgs(const OwningUTF8StringOrL10nIdArgs&) = delete;
  OwningUTF8StringOrL10nIdArgs& operator=(const OwningUTF8StringOrL10nIdArgs&) = delete;
public:
  explicit inline OwningUTF8StringOrL10nIdArgs()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrL10nIdArgs(OwningUTF8StringOrL10nIdArgs&& aOther);

  inline ~OwningUTF8StringOrL10nIdArgs()
  {
    Uninit();
  }

  nsCString&
  RawSetAsUTF8String();

  nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  L10nIdArgs&
  RawSetAsL10nIdArgs();

  L10nIdArgs&
  SetAsL10nIdArgs();

  inline bool
  IsL10nIdArgs() const
  {
    return mType == eL10nIdArgs;
  }

  inline L10nIdArgs&
  GetAsL10nIdArgs()
  {
    MOZ_RELEASE_ASSERT(IsL10nIdArgs(), "Wrong type!");
    return mValue.mL10nIdArgs.Value();
  }

  inline L10nIdArgs const &
  GetAsL10nIdArgs() const
  {
    MOZ_RELEASE_ASSERT(IsL10nIdArgs(), "Wrong type!");
    return mValue.mL10nIdArgs.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrL10nIdArgs&
  operator=(OwningUTF8StringOrL10nIdArgs&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToL10nIdArgs(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToL10nIdArgs(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyL10nIdArgs();
};


namespace Localization_Binding {

  typedef mozilla::intl::Localization NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::intl::Localization* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Localization,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Localization,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Localization,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Localization_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_LocalizationBinding_h
