add_setup(async function setup() {
  // This test covers the legacy implementation of the history sidebar
  // Coverage for the new is at browser/components/sidebar/tests/browser/browser_history_sidebar.js
  await SpecialPowers.pushPrefEnv({
    set: [["sidebar.revamp", false]],
  });
});

add_task(async function test() {
  let sidebar = document.getElementById("sidebar");

  // Visited pages listed by descending visit date.
  let pages = [
    "https://sidebar.mozilla.org/a",
    "https://sidebar.mozilla.org/b",
    "https://sidebar.mozilla.org/c",
    "https://www.mozilla.org/d",
  ];

  // Number of pages that will be filtered out by the search.
  const FILTERED_COUNT = 1;

  await PlacesUtils.history.clear();

  // Add some visited page.
  let time = Date.now();
  let places = [];
  for (let i = 0; i < pages.length; i++) {
    places.push({
      uri: NetUtil.newURI(pages[i]),
      visitDate: (time - i) * 1000,
      transition: PlacesUtils.history.TRANSITION_TYPED,
    });
  }
  await PlacesTestUtils.addVisits(places);

  await withSidebarTree("history", async function () {
    info("Set 'by last visited' view");
    sidebar.contentDocument.getElementById("bylastvisited").doCommand();
    let tree = sidebar.contentDocument.getElementById("historyTree");
    check_tree_order(tree, pages);

    // Set a search value.
    let searchBox = sidebar.contentDocument.getElementById("search-box");
    ok(searchBox, "search box is in context");
    await setSearch(searchBox, "sidebar.mozilla");
    check_tree_order(tree, pages, -FILTERED_COUNT);

    info("Reset the search");
    searchBox.clear();
    check_tree_order(tree, pages);
  });

  await PlacesUtils.history.clear();
});

function check_tree_order(tree, pages, aNumberOfRowsDelta = 0) {
  let treeView = tree.view;
  let columns = tree.columns;
  is(columns.count, 1, "There should be only 1 column in the sidebar");

  let found = 0;
  for (let i = 0; i < treeView.rowCount; i++) {
    let node = treeView.nodeForTreeIndex(i);
    // We could inherit delayed visits from previous tests, skip them.
    if (!pages.includes(node.uri)) {
      continue;
    }
    is(
      node.uri,
      pages[i],
      "Node is in correct position based on its visit date"
    );
    found++;
  }
  is(found, pages.length + aNumberOfRowsDelta, "Found all expected results");
}
