// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomCryptoMetrics_h
#define mozilla_GleanDomCryptoMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace webcrypto {
  /**
   * generated from webcrypto.alg
   * Algorithms used with WebCrypto (see table in WebCryptoTask.cpp)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBCRYPTO_ALG.
   */
  constexpr impl::CustomDistributionMetric alg(3710);

  /**
   * generated from webcrypto.extractable_enc
   */
  enum class ExtractableEncLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a key used in an encrypt/decrypt operation was marked as extractable
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBCRYPTO_EXTRACTABLE_ENC.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ExtractableEncLabel> extractable_enc(3711);

  /**
   * generated from webcrypto.extractable_generate
   */
  enum class ExtractableGenerateLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a generated key was marked as extractable
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBCRYPTO_EXTRACTABLE_GENERATE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ExtractableGenerateLabel> extractable_generate(3712);

  /**
   * generated from webcrypto.extractable_import
   */
  enum class ExtractableImportLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether an imported key was marked as extractable
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBCRYPTO_EXTRACTABLE_IMPORT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ExtractableImportLabel> extractable_import(3713);

  /**
   * generated from webcrypto.extractable_sig
   */
  enum class ExtractableSigLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a key used in a sign/verify operation was marked as extractable
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBCRYPTO_EXTRACTABLE_SIG.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ExtractableSigLabel> extractable_sig(3714);

  /**
   * generated from webcrypto.method
   * Methods invoked under window.crypto.subtle (0=encrypt, 1=decrypt, 2=sign, 3=verify, 4=digest, 5=generateKey, 6=deriveKey, 7=deriveBits, 8=importKey, 9=exportKey, 10=wrapKey, 11=unwrapKey)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram WEBCRYPTO_METHOD.
   */
  constexpr impl::CustomDistributionMetric method(3715);

  /**
   * generated from webcrypto.resolved
   */
  enum class ResolvedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a promise created by WebCrypto was resolved (vs rejected)
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram WEBCRYPTO_RESOLVED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ResolvedLabel> resolved(3716);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomCryptoMetrics_h
