/* THIS FILE IS AUTOGENERATED FROM HTMLElement.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_HTMLELEMENTBINDING_H_
#define DOM_HTMLELEMENTBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"
#include "nsGenericHTMLElement.h"

class nsGenericHTMLElement;

namespace mozilla {
namespace dom {

class HTMLUnknownElement;
struct NativePropertyHooks;
class OwningTogglePopoverOptionsOrBoolean;
class ProtoAndIfaceCache;
struct ShowPopoverOptionsAtoms;
struct TogglePopoverOptionsAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningTogglePopoverOptionsOrBoolean& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningTogglePopoverOptionsOrBoolean& aUnion);


class BooleanOrUnrestrictedDoubleOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  BooleanOrUnrestrictedDoubleOrString(const BooleanOrUnrestrictedDoubleOrString&) = delete;
  BooleanOrUnrestrictedDoubleOrString& operator=(const BooleanOrUnrestrictedDoubleOrString&) = delete;
public:
  explicit inline BooleanOrUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~BooleanOrUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningBooleanOrUnrestrictedDoubleOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eUnrestrictedDouble,
    eString
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eUnrestrictedDouble = TypeOrUninit::eUnrestrictedDouble,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningBooleanOrUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  OwningBooleanOrUnrestrictedDoubleOrString(OwningBooleanOrUnrestrictedDoubleOrString&& aOther);

  explicit inline OwningBooleanOrUnrestrictedDoubleOrString(const OwningBooleanOrUnrestrictedDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningBooleanOrUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] double&
  RawSetAsUnrestrictedDouble();

  [[nodiscard]] double&
  SetAsUnrestrictedDouble();

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_RELEASE_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningBooleanOrUnrestrictedDoubleOrString&
  operator=(OwningBooleanOrUnrestrictedDoubleOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningBooleanOrUnrestrictedDoubleOrString&
  operator=(const OwningBooleanOrUnrestrictedDoubleOrString& aOther);

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();

  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUnrestrictedDouble();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


struct ShowPopoverOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<nsGenericHTMLElement>> mSource;

  ShowPopoverOptions();

  explicit inline ShowPopoverOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ShowPopoverOptions(ShowPopoverOptions&& aOther) = default;

  explicit inline ShowPopoverOptions(const ShowPopoverOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mSource, "mSource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mSource);
  }

  ShowPopoverOptions&
  operator=(const ShowPopoverOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ShowPopoverOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastShowPopoverOptions : public ShowPopoverOptions
{
  inline FastShowPopoverOptions()
    : ShowPopoverOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct TogglePopoverOptions : public ShowPopoverOptions
{
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mForce;

  TogglePopoverOptions();

  explicit inline TogglePopoverOptions(const FastDictionaryInitializer& )
    : ShowPopoverOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  TogglePopoverOptions(TogglePopoverOptions&& aOther) = default;

  explicit inline TogglePopoverOptions(const TogglePopoverOptions& aOther)
    : ShowPopoverOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ShowPopoverOptions::TraverseForCC(aCallback, aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ShowPopoverOptions::UnlinkForCC();
  }

  TogglePopoverOptions&
  operator=(const TogglePopoverOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, TogglePopoverOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastTogglePopoverOptions : public TogglePopoverOptions
{
  inline FastTogglePopoverOptions()
    : TogglePopoverOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class TogglePopoverOptionsOrBoolean : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eTogglePopoverOptions,
    eBoolean
  };
public:
  enum class Type
  {
    eTogglePopoverOptions = TypeOrUninit::eTogglePopoverOptions,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastTogglePopoverOptions > mTogglePopoverOptions;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

  TogglePopoverOptionsOrBoolean(const TogglePopoverOptionsOrBoolean&) = delete;
  TogglePopoverOptionsOrBoolean& operator=(const TogglePopoverOptionsOrBoolean&) = delete;
public:
  explicit inline TogglePopoverOptionsOrBoolean()
    : mType(eUninitialized)
  {
  }

  inline ~TogglePopoverOptionsOrBoolean()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FastTogglePopoverOptions&
  RawSetAsTogglePopoverOptions()
  {
    if (mType == eTogglePopoverOptions) {
      return mValue.mTogglePopoverOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eTogglePopoverOptions;
    return mValue.mTogglePopoverOptions.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastTogglePopoverOptions&
  SetAsTogglePopoverOptions()
  {
    if (mType == eTogglePopoverOptions) {
      return mValue.mTogglePopoverOptions.Value();
    }
    Uninit();
    mType = eTogglePopoverOptions;
    return mValue.mTogglePopoverOptions.SetValue();
  }

  inline bool
  IsTogglePopoverOptions() const
  {
    return mType == eTogglePopoverOptions;
  }

  inline binding_detail::FastTogglePopoverOptions&
  GetAsTogglePopoverOptions()
  {
    MOZ_RELEASE_ASSERT(IsTogglePopoverOptions(), "Wrong type!");
    return mValue.mTogglePopoverOptions.Value();
  }

  inline const TogglePopoverOptions&
  GetAsTogglePopoverOptions() const
  {
    MOZ_RELEASE_ASSERT(IsTogglePopoverOptions(), "Wrong type!");
    return mValue.mTogglePopoverOptions.Value();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eTogglePopoverOptions: {
        DestroyTogglePopoverOptions();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
    }
  }

private:
  bool
  TrySetToTogglePopoverOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTogglePopoverOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyTogglePopoverOptions()
  {
    MOZ_RELEASE_ASSERT(IsTogglePopoverOptions(), "Wrong type!");
    mValue.mTogglePopoverOptions.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }
};


class OwningTogglePopoverOptionsOrBoolean : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningTogglePopoverOptionsOrBoolean& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eTogglePopoverOptions,
    eBoolean
  };
public:
  enum class Type
  {
    eTogglePopoverOptions = TypeOrUninit::eTogglePopoverOptions,
    eBoolean = TypeOrUninit::eBoolean
  };

private:
  union Value
  {
    UnionMember<TogglePopoverOptions > mTogglePopoverOptions;
    UnionMember<bool > mBoolean;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningTogglePopoverOptionsOrBoolean()
    : mType(eUninitialized)
  {
  }

  OwningTogglePopoverOptionsOrBoolean(OwningTogglePopoverOptionsOrBoolean&& aOther);

  explicit inline OwningTogglePopoverOptionsOrBoolean(const OwningTogglePopoverOptionsOrBoolean& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningTogglePopoverOptionsOrBoolean()
  {
    Uninit();
  }

  [[nodiscard]] TogglePopoverOptions&
  RawSetAsTogglePopoverOptions();

  [[nodiscard]] TogglePopoverOptions&
  SetAsTogglePopoverOptions();

  inline bool
  IsTogglePopoverOptions() const
  {
    return mType == eTogglePopoverOptions;
  }

  inline TogglePopoverOptions&
  GetAsTogglePopoverOptions()
  {
    MOZ_RELEASE_ASSERT(IsTogglePopoverOptions(), "Wrong type!");
    return mValue.mTogglePopoverOptions.Value();
  }

  inline TogglePopoverOptions const &
  GetAsTogglePopoverOptions() const
  {
    MOZ_RELEASE_ASSERT(IsTogglePopoverOptions(), "Wrong type!");
    return mValue.mTogglePopoverOptions.Value();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningTogglePopoverOptionsOrBoolean&
  operator=(OwningTogglePopoverOptionsOrBoolean&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningTogglePopoverOptionsOrBoolean&
  operator=(const OwningTogglePopoverOptionsOrBoolean& aOther);

private:
  bool
  TrySetToTogglePopoverOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToTogglePopoverOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyTogglePopoverOptions();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();
};


namespace HTMLElement_Binding {

  typedef nsGenericHTMLElement NativeType;

  bool
  Wrap(JSContext* aCx, nsGenericHTMLElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLElement,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace HTMLElement_Binding



namespace HTMLUnknownElement_Binding {

  typedef mozilla::dom::HTMLUnknownElement NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::HTMLUnknownElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLUnknownElement,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace HTMLUnknownElement_Binding



} // namespace mozilla::dom

#endif // DOM_HTMLELEMENTBINDING_H_
