#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSActorTypeUtils = 8175,
  JSProcessActorChild = 8192,
  JSProcessActorParent = 8212,
  JSWindowActorChild = 8233,
  JSWindowActorParent = 8252,
  KeyEvent = 8272,
  KeyboardEvent = 8281,
  KeyframeEffect = 8295,
  L10nFileSource = 8310,
  L10nOverlays = 8325,
  L10nRegistry = 8338,
  LargestContentfulPaint = 8351,
  LegacyMozTCPSocket = 8374,
  Localization = 8393,
  Location = 8406,
  Lock = 8415,
  LockManager = 8420,
  MIDIAccess = 8432,
  MIDIConnectionEvent = 8443,
  MIDIInput = 8463,
  MIDIInputMap = 8473,
  MIDIMessageEvent = 8486,
  MIDIOutput = 8503,
  MIDIOutputMap = 8514,
  MIDIPort = 8528,
  MLS = 8537,
  MLSGroupView = 8541,
  MOZ_debug = 8554,
  MatchGlob = 8564,
  MatchPattern = 8574,
  MatchPatternSet = 8587,
  MathMLElement = 8603,
  MediaCapabilities = 8617,
  MediaControlService = 8635,
  MediaController = 8655,
  MediaDeviceInfo = 8671,
  MediaDevices = 8687,
  MediaElementAudioSourceNode = 8700,
  MediaEncryptedEvent = 8728,
  MediaError = 8748,
  MediaKeyError = 8759,
  MediaKeyMessageEvent = 8773,
  MediaKeySession = 8794,
  MediaKeyStatusMap = 8810,
  MediaKeyStatusMap_Iterator = 8828,
  MediaKeySystemAccess = 8855,
  MediaKeys = 8876,
  MediaList = 8886,
  MediaMetadata = 8896,
  MediaQueryList = 8910,
  MediaQueryListEvent = 8925,
  MediaRecorder = 8945,
  MediaRecorderErrorEvent = 8959,
  MediaSession = 8983,
  MediaSource = 8996,
  MediaStream = 9008,
  MediaStreamAudioDestinationNode = 9020,
  MediaStreamAudioSourceNode = 9052,
  MediaStreamError = 9079,
  MediaStreamEvent = 9096,
  MediaStreamTrack = 9113,
  MediaStreamTrackAudioSourceNode = 9130,
  MediaStreamTrackEvent = 9162,
  MerchantValidationEvent = 9184,
  MessageBroadcaster = 9208,
  MessageChannel = 9227,
  MessageEvent = 9242,
  MessageListenerManager = 9255,
  MessagePort = 9278,
  MessageSender = 9290,
  MimeType = 9304,
  MimeTypeArray = 9313,
  MouseEvent = 9327,
  MouseScrollEvent = 9338,
  MozCanvasPrintState = 9355,
  MozDocumentMatcher = 9375,
  MozDocumentObserver = 9394,
  MozQueryInterface = 9414,
  MozSharedMap = 9432,
  MozSharedMap_Iterator = 9445,
  MozSharedMapChangeEvent = 9467,
  MozStorageAsyncStatementParams = 9491,
  MozStorageStatementParams = 9522,
  MozStorageStatementRow = 9548,
  MozWritableSharedMap = 9571,
  MutationObserver = 9592,
  MutationRecord = 9609,
  NamedNodeMap = 9624,
  NavigateEvent = 9637,
  Navigation = 9651,
  NavigationActivation = 9662,
  NavigationCurrentEntryChangeEvent = 9683,
  NavigationDestination = 9717,
  NavigationHistoryEntry = 9739,
  NavigationPrecommitController = 9762,
  NavigationPreloadManager = 9792,
  NavigationTransition = 9817,
  Navigator = 9838,
  NavigatorLogin = 9848,
  NetworkInformation = 9863,
  Node = 9882,
  NodeFilter = 9887,
  NodeIterator = 9898,
  NodeList = 9911,
  Notification = 9920,
  NotificationEvent = 9933,
  NotifyPaintEvent = 9951,
  OES_draw_buffers_indexed = 9968,
  OES_element_index_uint = 9993,
  OES_fbo_render_mipmap = 10016,
  OES_standard_derivatives = 10038,
  OES_texture_float = 10063,
  OES_texture_float_linear = 10081,
  OES_texture_half_float = 10106,
  OES_texture_half_float_linear = 10129,
  OES_vertex_array_object = 10159,
  OVR_multiview2 = 10183,
  OfflineAudioCompletionEvent = 10198,
  OfflineAudioContext = 10226,
  OffscreenCanvas = 10246,
  OffscreenCanvasRenderingContext2D = 10262,
  Option = 10296,
  OscillatorNode = 10303,
  PageTransitionEvent = 10318,
  PaintRequest = 10338,
  PaintRequestList = 10351,
  PaintWorkletGlobalScope = 10368,
  PannerNode = 10392,
  ParentProcessMessageManager = 10403,
  Path2D = 10431,
  PathUtils = 10438,
  PaymentAddress = 10448,
  PaymentMethodChangeEvent = 10463,
  PaymentRequest = 10488,
  PaymentRequestUpdateEvent = 10503,
  PaymentResponse = 10529,
  Performance = 10545,
  PerformanceEntry = 10557,
  PerformanceEntryEvent = 10574,
  PerformanceEventTiming = 10596,
  PerformanceMark = 10619,
  PerformanceMeasure = 10635,
  PerformanceNavigation = 10654,
  PerformanceNavigationTiming = 10676,
  PerformanceObserver = 10704,
  PerformanceObserverEntryList = 10724,
  PerformancePaintTiming = 10753,
  PerformanceResourceTiming = 10776,
  PerformanceServerTiming = 10802,
  PerformanceTiming = 10826,
  PeriodicWave = 10844,
  PermissionStatus = 10857,
  Permissions = 10874,
  PlacesBookmark = 10886,
  PlacesBookmarkAddition = 10901,
  PlacesBookmarkChanged = 10924,
  PlacesBookmarkGuid = 10946,
  PlacesBookmarkKeyword = 10965,
  PlacesBookmarkMoved = 10987,
  PlacesBookmarkRemoved = 11007,
  PlacesBookmarkTags = 11029,
  PlacesBookmarkTime = 11048,
  PlacesBookmarkTitle = 11067,
  PlacesBookmarkUrl = 11087,
  PlacesEvent = 11105,
  PlacesEventCounts = 11117,
  PlacesFavicon = 11135,
  PlacesHistoryCleared = 11149,
  PlacesObservers = 11170,
  PlacesPurgeCaches = 11186,
  PlacesRanking = 11204,
  PlacesVisit = 11218,
  PlacesVisitRemoved = 11230,
  PlacesVisitTitle = 11249,
  PlacesWeakCallbackWrapper = 11266,
  Plugin = 11292,
  PluginArray = 11299,
  PluginCrashedEvent = 11311,
  PointerEvent = 11330,
  PopStateEvent = 11343,
  PopupBlockedEvent = 11357,
  PopupPositionedEvent = 11375,
  PositionStateEvent = 11396,
  PrecompiledScript = 11415,
  PrivateAttribution = 11433,
  ProcessMessageManager = 11452,
  ProcessingInstruction = 11474,
  ProgressEvent = 11496,
  PromiseDebugging = 11510,
  PromiseNativeHandler = 11527,
  PromiseRejectionEvent = 11548,
  PublicKeyCredential = 11570,
  PushEvent = 11590,
  PushManager = 11600,
  PushManagerImpl = 11612,
  PushMessageData = 11628,
  PushSubscription = 11644,
  PushSubscriptionChangeEvent = 11661,
  PushSubscriptionOptions = 11689,
  RadioNodeList = 11713,
  Range = 11727,
  ReadableByteStreamController = 11733,
  ReadableStream = 11762,
  ReadableStream_AsyncIterator = 11777,
  ReadableStreamBYOBReader = 11806,
  ReadableStreamBYOBRequest = 11831,
  ReadableStreamDefaultController = 11857,
  ReadableStreamDefaultReader = 11889,
  RedirectBlockedEvent = 11917,
  Report = 11938,
  ReportBody = 11945,
  ReportingObserver = 11956,
  Request = 11974,
  ResizeObserver = 11982,
  ResizeObserverEntry = 11997,
  ResizeObserverSize = 12017,
  Response = 12036,
  SVGAElement = 12045,
  SVGAngle = 12057,
  SVGAnimateElement = 12066,
  SVGAnimateMotionElement = 12084,
  SVGAnimateTransformElement = 12108,
  SVGAnimatedAngle = 12135,
  SVGAnimatedBoolean = 12152,
  SVGAnimatedEnumeration = 12171,
  SVGAnimatedInteger = 12194,
  SVGAnimatedLength = 12213,
  SVGAnimatedLengthList = 12231,
  SVGAnimatedNumber = 12253,
  SVGAnimatedNumberList = 12271,
  SVGAnimatedPreserveAspectRatio = 12293,
  SVGAnimatedRect = 12324,
  SVGAnimatedString = 12340,
  SVGAnimatedTransformList = 12358,
  SVGAnimationElement = 12383,
  SVGCircleElement = 12403,
  SVGClipPathElement = 12420,
  SVGComponentTransferFunctionElement = 12439,
  SVGDefsElement = 12475,
  SVGDescElement = 12490,
  SVGElement = 12505,
  SVGEllipseElement = 12516,
  SVGFEBlendElement = 12534,
  SVGFEColorMatrixElement = 12552,
  SVGFEComponentTransferElement = 12576,
  SVGFECompositeElement = 12606,
  SVGFEConvolveMatrixElement = 12628,
  SVGFEDiffuseLightingElement = 12655,
  SVGFEDisplacementMapElement = 12683,
  SVGFEDistantLightElement = 12711,
  SVGFEDropShadowElement = 12736,
  SVGFEFloodElement = 12759,
  SVGFEFuncAElement = 12777,
  SVGFEFuncBElement = 12795,
  SVGFEFuncGElement = 12813,
  SVGFEFuncRElement = 12831,
  SVGFEGaussianBlurElement = 12849,
  SVGFEImageElement = 12874,
  SVGFEMergeElement = 12892,
  SVGFEMergeNodeElement = 12910,
  SVGFEMorphologyElement = 12932,
  SVGFEOffsetElement = 12955,
  SVGFEPointLightElement = 12974,
  SVGFESpecularLightingElement = 12997,
  SVGFESpotLightElement = 13026,
  SVGFETileElement = 13048,
  SVGFETurbulenceElement = 13065,
  SVGFilterElement = 13088,
  SVGForeignObjectElement = 13105,
  SVGGElement = 13129,
  SVGGeometryElement = 13141,
  SVGGradientElement = 13160,
  SVGGraphicsElement = 13179,
  SVGImageElement = 13198,
  SVGLength = 13214,
  SVGLengthList = 13224,
  SVGLineElement = 13238,
  SVGLinearGradientElement = 13253,
  SVGMPathElement = 13278,
  SVGMarkerElement = 13294,
  SVGMaskElement = 13311,
  SVGMatrix = 13326,
  SVGMetadataElement = 13336,
  SVGNumber = 13355,
  SVGNumberList = 13365,
  SVGPathElement = 13379,
  SVGPathSegment = 13394,
  SVGPatternElement = 13409,
  SVGPoint = 13427,
  SVGPointList = 13436,
  SVGPolygonElement = 13449,
  SVGPolylineElement = 13467,
  SVGPreserveAspectRatio = 13486,
  SVGRadialGradientElement = 13509,
  SVGRect = 13534,
  SVGRectElement = 13542,
  SVGSVGElement = 13557,
  SVGScriptElement = 13571,
  SVGSetElement = 13588,
  SVGStopElement = 13602,
  SVGStringList = 13617,
  SVGStyleElement = 13631,
  SVGSwitchElement = 13647,
  SVGSymbolElement = 13664,
  SVGTSpanElement = 13681,
  SVGTextContentElement = 13697,
  SVGTextElement = 13719,
  SVGTextPathElement = 13734,
  SVGTextPositioningElement = 13753,
  SVGTitleElement = 13779,
  SVGTransform = 13795,
  SVGTransformList = 13808,
  SVGUnitTypes = 13825,
  SVGUseElement = 13838,
  SVGViewElement = 13852,
  Sanitizer = 13867,
  Scheduler = 13877,
  Screen = 13887,
  ScreenLuminance = 13894,
  ScreenOrientation = 13910,
  ScriptProcessorNode = 13928,
  ScrollAreaEvent = 13948,
  SecurityPolicyViolationEvent = 13964,
  Selection = 13993,
  ServiceWorker = 14003,
  ServiceWorkerContainer = 14017,
  ServiceWorkerGlobalScope = 14040,
  ServiceWorkerRegistration = 14065,
  SessionStoreFormData = 14091,
  SessionStoreScrollData = 14112,
  SessionStoreUtils = 14135,
  ShadowRealmGlobalScope = 14153,
  ShadowRoot = 14176,
  SharedWorker = 14187,
  SharedWorkerGlobalScope = 14200,
  SimpleGestureEvent = 14224,
  SourceBuffer = 14243,
  SourceBufferList = 14256,
  SpeechGrammar = 14273,
  SpeechGrammarList = 14287,
  SpeechRecognition = 14305,
  SpeechRecognitionAlternative = 14323,
  SpeechRecognitionError = 14352,
  SpeechRecognitionEvent = 14375,
  SpeechRecognitionResult = 14398,
  SpeechRecognitionResultList = 14422,
  SpeechSynthesis = 14450,
  SpeechSynthesisErrorEvent = 14466,
  SpeechSynthesisEvent = 14492,
  SpeechSynthesisUtterance = 14513,
  SpeechSynthesisVoice = 14538,
  StaticRange = 14559,
  StereoPannerNode = 14571,
  Storage = 14588,
  StorageEvent = 14596,
  StorageManager = 14609,
  StreamFilter = 14624,
  StreamFilterDataEvent = 14637,
  StructuredCloneHolder = 14659,
  StructuredCloneTester = 14681,
  StylePropertyMap = 14703,
  StylePropertyMapReadOnly = 14720,
  StylePropertyMapReadOnly_Iterator = 14745,
  StyleSheet = 14779,
  StyleSheetApplicableStateChangeEvent = 14790,
  StyleSheetList = 14827,
  StyleSheetRemovedEvent = 14842,
  SubmitEvent = 14865,
  SubtleCrypto = 14877,
  SyncMessageSender = 14890,
  SyncReadFile = 14908,
  TCPServerSocket = 14921,
  TCPServerSocketEvent = 14937,
  TCPSocket = 14958,
  TCPSocketErrorEvent = 14968,
  TCPSocketEvent = 14988,
  TaskController = 15003,
  TaskPriorityChangeEvent = 15018,
  TaskSignal = 15042,
  Tensor = 15053,
  TestUtils = 15060,
  TestingDeprecatedInterface = 15070,
  Text = 15097,
  TextClause = 15102,
  TextDecoder = 15113,
  TextDecoderStream = 15125,
  TextEncoder = 15143,
  TextEncoderStream = 15155,
  TextEvent = 15173,
  TextMetrics = 15183,
  TextTrack = 15195,
  TextTrackCue = 15205,
  TextTrackCueList = 15218,
  TextTrackList = 15235,
  TimeEvent = 15249,
  TimeRanges = 15259,
  ToggleEvent = 15270,
  Touch = 15282,
  TouchEvent = 15288,
  TouchList = 15299,
  TrackEvent = 15309,
  TransformStream = 15320,
  TransformStreamDefaultController = 15336,
  TransitionEvent = 15369,
  TreeColumn = 15385,
  TreeColumns = 15396,
  TreeContentView = 15408,
  TreeWalker = 15424,
  TrustedHTML = 15435,
  TrustedScript = 15447,
  TrustedScriptURL = 15461,
  TrustedTypePolicy = 15478,
  TrustedTypePolicyFactory = 15496,
  UDPMessageEvent = 15521,
  UDPSocket = 15537,
  UIEvent = 15547,
  URL = 15555,
  URLPattern = 15559,
  URLSearchParams = 15570,
  URLSearchParams_Iterator = 15586,
  UniFFIPointer = 15611,
  UniFFIScaffolding = 15625,
  UserActivation = 15643,
  UserInteraction = 15658,
  UserProximityEvent = 15674,
  VRDisplay = 15693,
  VRDisplayCapabilities = 15703,
  VRDisplayEvent = 15725,
  VREyeParameters = 15740,
  VRFieldOfView = 15756,
  VRFrameData = 15770,
  VRMockController = 15782,
  VRMockDisplay = 15799,
  VRPose = 15813,
  VRServiceTest = 15820,
  VRStageParameters = 15834,
  VTTCue = 15852,
  VTTRegion = 15859,
  ValidityState = 15869,
  VideoColorSpace = 15883,
  VideoDecoder = 15899,
  VideoEncoder = 15912,
  VideoFrame = 15925,
  VideoPlaybackQuality = 15936,
  VideoTrack = 15957,
  VideoTrackList = 15968,
  ViewTransition = 15983,
  ViewTransitionTypeSet = 15998,
  VisualViewport = 16020,
  WEBGL_color_buffer_float = 16035,
  WEBGL_compressed_texture_astc = 16060,
  WEBGL_compressed_texture_etc = 16090,
  WEBGL_compressed_texture_etc1 = 16119,
  WEBGL_compressed_texture_pvrtc = 16149,
  WEBGL_compressed_texture_s3tc = 16180,
  WEBGL_compressed_texture_s3tc_srgb = 16210,
  WEBGL_debug_renderer_info = 16245,
  WEBGL_debug_shaders = 16271,
  WEBGL_depth_texture = 16291,
  WEBGL_draw_buffers = 16311,
  WEBGL_explicit_present = 16330,
  WEBGL_lose_context = 16353,
  WEBGL_provoking_vertex = 16372,
  WGSLLanguageFeatures = 16395,
  WakeLock = 16416,
  WakeLockSentinel = 16425,
  WaveShaperNode = 16442,
  WebExtensionContentScript = 16457,
  WebExtensionPolicy = 16483,
  WebGL2RenderingContext = 16502,
  WebGLActiveInfo = 16525,
  WebGLBuffer = 16541,
  WebGLContextEvent = 16553,
  WebGLFramebuffer = 16571,
  WebGLProgram = 16588,
  WebGLQuery = 16601,
  WebGLRenderbuffer = 16612,
  WebGLRenderingContext = 16630,
  WebGLSampler = 16652,
  WebGLShader = 16665,
  WebGLShaderPrecisionFormat = 16677,
  WebGLSync = 16704,
  WebGLTexture = 16714,
  WebGLTransformFeedback = 16727,
  WebGLUniformLocation = 16750,
  WebGLVertexArrayObject = 16771,
  WebKitCSSMatrix = 16794,
  WebSocket = 16810,
  WebTransport = 16820,
  WebTransportBidirectionalStream = 16833,
  WebTransportDatagramDuplexStream = 16865,
  WebTransportError = 16898,
  WebTransportReceiveStream = 16916,
  WebTransportSendStream = 16942,
  WheelEvent = 16965,
  Window = 16976,
  WindowClient = 16983,
  WindowContext = 16996,
  WindowGlobalChild = 17010,
  WindowGlobalParent = 17028,
  WindowRoot = 17047,
  Worker = 17058,
  WorkerDebuggerGlobalScope = 17065,
  WorkerGlobalScope = 17091,
  WorkerLocation = 17109,
  WorkerNavigator = 17124,
  WorkerTestUtils = 17140,
  Worklet = 17156,
  WorkletGlobalScope = 17164,
  WritableStream = 17183,
  WritableStreamDefaultController = 17198,
  WritableStreamDefaultWriter = 17230,
  XMLDocument = 17258,
  XMLHttpRequest = 17270,
  XMLHttpRequestEventTarget = 17285,
  XMLHttpRequestUpload = 17311,
  XMLSerializer = 17332,
  XPathEvaluator = 17346,
  XPathExpression = 17361,
  XPathResult = 17377,
  XRBoundedReferenceSpace = 17389,
  XRFrame = 17413,
  XRInputSource = 17421,
  XRInputSourceArray = 17435,
  XRInputSourceEvent = 17454,
  XRInputSourcesChangeEvent = 17473,
  XRPose = 17499,
  XRReferenceSpace = 17506,
  XRReferenceSpaceEvent = 17523,
  XRRenderState = 17545,
  XRRigidTransform = 17559,
  XRSession = 17576,
  XRSessionEvent = 17586,
  XRSpace = 17601,
  XRSystem = 17609,
  XRView = 17618,
  XRViewerPose = 17625,
  XRViewport = 17638,
  XRWebGLLayer = 17649,
  XSLTProcessor = 17662,
  XULCommandEvent = 17676,
  XULElement = 17692,
  XULFrameElement = 17703,
  XULMenuElement = 17719,
  XULPopupElement = 17734,
  XULResizerElement = 17750,
  XULTextElement = 17768,
  XULTreeElement = 17783,
  console = 17798,
  webkitSpeechGrammar = 17806,
  webkitSpeechGrammarList = 17826,
  webkitSpeechRecognition = 17850,
  webkitURL = 17874,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
