/* THIS FILE IS AUTOGENERATED FROM URLPattern.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_URLPATTERNBINDING_H_
#define DOM_URLPATTERNBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class OwningUTF8StringOrURLPatternInit;
class OwningUTF8StringOrUndefined;
class ProtoAndIfaceCache;
class URLPattern;
struct URLPatternComponentResult;
struct URLPatternComponentResultAtoms;
struct URLPatternInitAtoms;
struct URLPatternOptionsAtoms;
struct URLPatternResultAtoms;
class UTF8StringOrURLPatternInit;
class UTF8StringOrUndefined;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

struct URLPatternInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mBaseURL;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mHash;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mHostname;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mPassword;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mPathname;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mPort;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mProtocol;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mSearch;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mUsername;

  URLPatternInit();

  explicit inline URLPatternInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  URLPatternInit(URLPatternInit&& aOther) = default;

  explicit inline URLPatternInit(const URLPatternInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  URLPatternInit&
  operator=(const URLPatternInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, URLPatternInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastURLPatternInit : public URLPatternInit
{
  inline FastURLPatternInit()
    : URLPatternInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct URLPatternOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreCase;

  URLPatternOptions();

  explicit inline URLPatternOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  URLPatternOptions(URLPatternOptions&& aOther) = default;

  explicit inline URLPatternOptions(const URLPatternOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  URLPatternOptions&
  operator=(const URLPatternOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, URLPatternOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastURLPatternOptions : public URLPatternOptions
{
  inline FastURLPatternOptions()
    : URLPatternOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrUndefined : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUndefined
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrUndefined(const UTF8StringOrUndefined&) = delete;
  UTF8StringOrUndefined& operator=(const UTF8StringOrUndefined&) = delete;
public:
  explicit inline UTF8StringOrUndefined()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eUndefined: {
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrUndefined : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUndefined
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUndefined = TypeOrUninit::eUndefined
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrUndefined()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrUndefined(OwningUTF8StringOrUndefined&& aOther);

  explicit inline OwningUTF8StringOrUndefined(const OwningUTF8StringOrUndefined& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrUndefined()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline bool
  IsUndefined() const
  {
    return mType == eUndefined;
  }

  inline void
  SetUndefined()
  {
    Uninit();
    mType = eUndefined;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrUndefined&
  operator=(OwningUTF8StringOrUndefined&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrUndefined&
  operator=(const OwningUTF8StringOrUndefined& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();
};


struct URLPatternComponentResult : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Record<nsCString, OwningUTF8StringOrUndefined>> mGroups;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mInput;

  URLPatternComponentResult();

  explicit inline URLPatternComponentResult(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  URLPatternComponentResult(URLPatternComponentResult&& aOther) = default;

private:
  URLPatternComponentResult(const URLPatternComponentResult&) = delete;
  URLPatternComponentResult& operator=(const URLPatternComponentResult&) = delete;

  static bool
  InitIds(JSContext* cx, URLPatternComponentResultAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastURLPatternComponentResult : public URLPatternComponentResult
{
  inline FastURLPatternComponentResult()
    : URLPatternComponentResult(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrURLPatternInit : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eURLPatternInit
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eURLPatternInit = TypeOrUninit::eURLPatternInit
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<binding_detail::FastURLPatternInit > mURLPatternInit;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrURLPatternInit(const UTF8StringOrURLPatternInit&) = delete;
  UTF8StringOrURLPatternInit& operator=(const UTF8StringOrURLPatternInit&) = delete;
public:
  explicit inline UTF8StringOrURLPatternInit()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrURLPatternInit()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline binding_detail::FastURLPatternInit&
  RawSetAsURLPatternInit()
  {
    if (mType == eURLPatternInit) {
      return mValue.mURLPatternInit.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eURLPatternInit;
    return mValue.mURLPatternInit.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastURLPatternInit&
  SetAsURLPatternInit()
  {
    if (mType == eURLPatternInit) {
      return mValue.mURLPatternInit.Value();
    }
    Uninit();
    mType = eURLPatternInit;
    return mValue.mURLPatternInit.SetValue();
  }

  inline bool
  IsURLPatternInit() const
  {
    return mType == eURLPatternInit;
  }

  inline binding_detail::FastURLPatternInit&
  GetAsURLPatternInit()
  {
    MOZ_RELEASE_ASSERT(IsURLPatternInit(), "Wrong type!");
    return mValue.mURLPatternInit.Value();
  }

  inline const URLPatternInit&
  GetAsURLPatternInit() const
  {
    MOZ_RELEASE_ASSERT(IsURLPatternInit(), "Wrong type!");
    return mValue.mURLPatternInit.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eURLPatternInit: {
        DestroyURLPatternInit();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToURLPatternInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToURLPatternInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyURLPatternInit()
  {
    MOZ_RELEASE_ASSERT(IsURLPatternInit(), "Wrong type!");
    mValue.mURLPatternInit.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrURLPatternInit : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eURLPatternInit
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eURLPatternInit = TypeOrUninit::eURLPatternInit
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<URLPatternInit > mURLPatternInit;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrURLPatternInit()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrURLPatternInit(OwningUTF8StringOrURLPatternInit&& aOther);

  explicit inline OwningUTF8StringOrURLPatternInit(const OwningUTF8StringOrURLPatternInit& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrURLPatternInit()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] URLPatternInit&
  RawSetAsURLPatternInit();

  [[nodiscard]] URLPatternInit&
  SetAsURLPatternInit();

  inline bool
  IsURLPatternInit() const
  {
    return mType == eURLPatternInit;
  }

  inline URLPatternInit&
  GetAsURLPatternInit()
  {
    MOZ_RELEASE_ASSERT(IsURLPatternInit(), "Wrong type!");
    return mValue.mURLPatternInit.Value();
  }

  inline URLPatternInit const &
  GetAsURLPatternInit() const
  {
    MOZ_RELEASE_ASSERT(IsURLPatternInit(), "Wrong type!");
    return mValue.mURLPatternInit.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningUTF8StringOrURLPatternInit&
  operator=(OwningUTF8StringOrURLPatternInit&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrURLPatternInit&
  operator=(const OwningUTF8StringOrURLPatternInit& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToURLPatternInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToURLPatternInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyURLPatternInit();
};


struct URLPatternResult : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mHash;
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mHostname;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningUTF8StringOrURLPatternInit>> mInputs;
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mPassword;
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mPathname;
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mPort;
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mProtocol;
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mSearch;
  MOZ_INIT_OUTSIDE_CTOR Optional<URLPatternComponentResult> mUsername;

  URLPatternResult();

  explicit inline URLPatternResult(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  URLPatternResult(URLPatternResult&& aOther) = default;

private:
  URLPatternResult(const URLPatternResult&) = delete;
  URLPatternResult& operator=(const URLPatternResult&) = delete;

  static bool
  InitIds(JSContext* cx, URLPatternResultAtoms* atomsCache);

public:
  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastURLPatternResult : public URLPatternResult
{
  inline FastURLPatternResult()
    : URLPatternResult(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace URLPattern_Binding {

  typedef mozilla::dom::URLPattern NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::URLPattern* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::URLPattern,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace URLPattern_Binding



} // namespace mozilla::dom

#endif // DOM_URLPATTERNBINDING_H_
