// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanSessionstoreMetrics_h
#define mozilla_GleanSessionstoreMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_engagement {
  /**
   * generated from browser.engagement.sessionrestore_interstitial
   * Whether we show about:sessionrestore or not. Split by key, which indicates why we showed the item or not. Specifically, 'deferred_restore' means we didn't autorestore and thus didn't show the interstitial; 'autorestore' indicates we autorestored without showing the interstitial. 'shown_old_session', 'shown_only_about_welcomeback', 'shown_many_crashes', 'shown_many_crashes_old_session' all indicate we did show the interstitial because of a crash, and the text after 'shown' indicates what secondary reason there was to show this page (as we don't show it for 'just' one crash). This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.sessionrestore_interstitial.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> sessionrestore_interstitial(15);
}

namespace session_restore {
  /**
   * generated from session_restore.all_files_corrupt
   */
  enum class AllFilesCorruptLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Session restore: Whether none of the backup files contained parse-able JSON
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram FX_SESSION_RESTORE_ALL_FILES_CORRUPT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, AllFilesCorruptLabel> all_files_corrupt(848);

  /**
   * generated from session_restore.auto_restore_duration_until_eager_tabs_restored
   * Session restore: If the browser is setup to auto-restore tabs, this probe measures the time elapsed between the instant we start Session Restore and the instant we have finished restoring tabs eagerly. At this stage, the tabs that are restored on demand are not restored yet.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_AUTO_RESTORE_DURATION_UNTIL_EAGER_TABS_RESTORED_MS.
   */
  constexpr impl::TimingDistributionMetric auto_restore_duration_until_eager_tabs_restored(849);

  /**
   * generated from session_restore.backup_can_be_loaded_session_file
   */
  struct BackupCanBeLoadedSessionFileExtra {
    mozilla::Maybe<nsCString> canLoad;
    mozilla::Maybe<nsCString> loadfailReason;
    mozilla::Maybe<nsCString> pathKey;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (canLoad) {
        extraKeys.AppendElement()->AssignASCII("can_load");
        extraValues.EmplaceBack(canLoad.value());
      }
      if (loadfailReason) {
        extraKeys.AppendElement()->AssignASCII("loadfail_reason");
        extraValues.EmplaceBack(loadfailReason.value());
      }
      if (pathKey) {
        extraKeys.AppendElement()->AssignASCII("path_key");
        extraValues.EmplaceBack(pathKey.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a file is able to be successfully read on startup This event was generated to correspond to the Legacy Telemetry event session_restore.backup_can_be_loaded#session_file.
   */
  constexpr impl::EventMetric<BackupCanBeLoadedSessionFileExtra> backup_can_be_loaded_session_file(850);

  /**
   * generated from session_restore.collect_all_windows_data
   * Session restore: Time to collect all window data (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_COLLECT_ALL_WINDOWS_DATA_MS.
   */
  constexpr impl::TimingDistributionMetric collect_all_windows_data(851);

  /**
   * generated from session_restore.collect_data
   * Session restore: Time to collect all window and tab data (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_COLLECT_DATA_MS.
   */
  constexpr impl::TimingDistributionMetric collect_data(852);

  /**
   * generated from session_restore.collect_session_history
   * Session restore: Duration of session history collection in the parent process (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_COLLECT_SESSION_HISTORY_MS.
   */
  constexpr impl::TimingDistributionMetric collect_session_history(853);

  /**
   * generated from session_restore.corrupt_file
   */
  enum class CorruptFileLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Session restore: Whether the file read on startup contained parse-able JSON
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram FX_SESSION_RESTORE_CORRUPT_FILE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CorruptFileLabel> corrupt_file(854);

  /**
   * generated from session_restore.file_size_bytes
   * Session restore: The size of file sessionstore.js (bytes)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_FILE_SIZE_BYTES.
   */
  constexpr impl::MemoryDistributionMetric file_size_bytes(855);

  /**
   * generated from session_restore.manual_restore_duration_until_eager_tabs_restored
   * Session restore: If a session is restored by the user clicking on 'Restore Session', this probe measures the time elapsed between the instant the user has clicked and the instant we have finished restoring tabs eagerly. At this stage, the tabs that are restored on demand are not restored yet.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_MANUAL_RESTORE_DURATION_UNTIL_EAGER_TABS_RESTORED_MS.
   */
  constexpr impl::TimingDistributionMetric manual_restore_duration_until_eager_tabs_restored(856);

  /**
   * generated from session_restore.number_of_eager_tabs_restored
   * Session restore: Number of tabs restored eagerly in the session that has just been restored.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_SESSION_RESTORE_NUMBER_OF_EAGER_TABS_RESTORED.
   */
  constexpr impl::CustomDistributionMetric number_of_eager_tabs_restored(857);

  /**
   * generated from session_restore.number_of_tabs_restored
   * Session restore: Number of tabs in the session that has just been restored.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_NUMBER_OF_TABS_RESTORED.
   */
  constexpr impl::CustomDistributionMetric number_of_tabs_restored(858);

  /**
   * generated from session_restore.number_of_windows_restored
   * Session restore: Number of windows in the session that has just been restored.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram FX_SESSION_RESTORE_NUMBER_OF_WINDOWS_RESTORED.
   */
  constexpr impl::CustomDistributionMetric number_of_windows_restored(859);

  /**
   * generated from session_restore.read_file
   * Session restore: Time to read the session data from the file on disk (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_READ_FILE_MS.
   */
  constexpr impl::TimingDistributionMetric read_file(860);

  /**
   * generated from session_restore.restore_window
   * Session restore: Time spent blocking the main thread while restoring a window state (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_RESTORE_WINDOW_MS.
   */
  constexpr impl::TimingDistributionMetric restore_window(861);

  /**
   * generated from session_restore.shutdown_flush_all_outcomes
   */
  enum class ShutdownFlushAllOutcomesLabel: uint16_t {
    eTimedOut = 0,
    eAbnormalContentShutdown = 1,
    eOopFrameloaderCrashed = 2,
    eComplete = 3,
    e__Other__,
  };
  /**
   * The count of time-outs, abnormal shutdown and frameloader crashes observed during an async shutdown
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ShutdownFlushAllOutcomesLabel> shutdown_flush_all_outcomes(862);

  /**
   * generated from session_restore.shutdown_ok
   */
  enum class ShutdownOkLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Did the browser start after a successful shutdown
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram SHUTDOWN_OK.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ShutdownOkLabel> shutdown_ok(863);

  /**
   * generated from session_restore.shutdown_success_session_startup
   */
  struct ShutdownSuccessSessionStartupExtra {
    mozilla::Maybe<nsCString> shutdownOk;
    mozilla::Maybe<nsCString> shutdownReason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (shutdownOk) {
        extraKeys.AppendElement()->AssignASCII("shutdown_ok");
        extraValues.EmplaceBack(shutdownOk.value());
      }
      if (shutdownReason) {
        extraKeys.AppendElement()->AssignASCII("shutdown_reason");
        extraValues.EmplaceBack(shutdownReason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Report shutdown success This event was generated to correspond to the Legacy Telemetry event session_restore.shutdown_success#session_startup.
   */
  constexpr impl::EventMetric<ShutdownSuccessSessionStartupExtra> shutdown_success_session_startup(864);

  /**
   * generated from session_restore.shutdown_type
   */
  enum class ShutdownTypeLabel: uint16_t {
    eSync = 0,
    eAsync = 1,
    e__Other__,
  };
  /**
   * On quit-application-granted, is the shutdown sync (immediate) or async
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ShutdownTypeLabel> shutdown_type(865);

  /**
   * generated from session_restore.startup_init_session
   * Session restore: Time it takes to prepare the data structures for restoring a session (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_STARTUP_INIT_SESSION_MS.
   */
  constexpr impl::TimingDistributionMetric startup_init_session(866);

  /**
   * generated from session_restore.startup_onload_initial_window
   * Session restore: Time it takes to finish restoration once we have first opened a window (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_STARTUP_ONLOAD_INITIAL_WINDOW_MS.
   */
  constexpr impl::TimingDistributionMetric startup_onload_initial_window(867);

  /**
   * generated from session_restore.startup_timeline
   */
  enum class StartupTimelineLabel: uint16_t {
    eSessionrestoreinitialized = 0,
    eSessionrestorerestoring = 1,
    e__Other__,
  };
  /**
   * Events on the startup timeline, in millis since process creation.
   * Previously carried in Legacy "main" ping `simpleMeasurements`.
   */
  constexpr impl::Labeled<impl::QuantityMetric, StartupTimelineLabel> startup_timeline(868);

  /**
   * generated from session_restore.write_file
   * Session restore: Time to write the session data to the file on disk (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_SESSION_RESTORE_WRITE_FILE_MS.
   */
  constexpr impl::TimingDistributionMetric write_file(869);
}

} // namespace mozilla::glean

#endif // mozilla_GleanSessionstoreMetrics_h
